/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.InMemoryExchangeSinkOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryExchange {
    private static final DataSize DEFAULT_MAX_BUFFERED_BYTES = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private final List<Type> types;
    private final List<Queue<PageReference>> buffers;
    private final long maxBufferedBytes;
    @GuardedBy(value="this")
    private boolean finishing;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private int sinkFactories;
    @GuardedBy(value="this")
    private int sinks;
    @GuardedBy(value="this")
    private long bufferBytes;
    @GuardedBy(value="this")
    private SettableFuture<?> readerFuture;
    @GuardedBy(value="this")
    private SettableFuture<?> writerFuture;

    public InMemoryExchange(List<Type> types) {
        this(types, 1, DEFAULT_MAX_BUFFERED_BYTES);
    }

    public InMemoryExchange(List<Type> types, int bufferCount) {
        this(types, bufferCount, DEFAULT_MAX_BUFFERED_BYTES);
    }

    public InMemoryExchange(List<Type> types, int bufferCount, DataSize maxBufferedBytes) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        ImmutableList.Builder buffers = ImmutableList.builder();
        for (int i = 0; i < bufferCount; ++i) {
            buffers.add(new ConcurrentLinkedQueue());
        }
        this.buffers = buffers.build();
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be greater than zero");
        this.maxBufferedBytes = maxBufferedBytes.toBytes();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getBufferCount() {
        return this.buffers.size();
    }

    public synchronized OperatorFactory createSinkFactory(int operatorId) {
        ++this.sinkFactories;
        return new InMemoryExchangeSinkOperatorFactory(operatorId);
    }

    private synchronized void addSink() {
        Preconditions.checkState((this.sinkFactories > 0 ? 1 : 0) != 0, (Object)"All sink factories already closed");
        ++this.sinks;
    }

    public synchronized void sinkFinished() {
        Preconditions.checkState((this.sinks != 0 ? 1 : 0) != 0, (Object)"All sinks are already complete");
        --this.sinks;
        this.updateState();
    }

    public synchronized void noMoreSinkFactories() {
        this.noMoreSinkFactories = true;
        this.updateState();
    }

    private synchronized void sinkFactoryClosed() {
        Preconditions.checkState((this.sinkFactories != 0 ? 1 : 0) != 0, (Object)"All sinks factories are already closed");
        --this.sinkFactories;
        this.updateState();
    }

    private void updateState() {
        if (this.noMoreSinkFactories && this.sinkFactories == 0 && this.sinks == 0) {
            this.finish();
        }
    }

    public synchronized boolean isFinishing() {
        return this.finishing;
    }

    public synchronized void finish() {
        this.finishing = true;
        this.notifyBlockedReaders();
        this.notifyBlockedWriters();
    }

    public synchronized boolean isFinished(int bufferIndex) {
        return this.finishing && this.buffers.get(bufferIndex).isEmpty();
    }

    public synchronized void addPage(Page page) {
        if (this.finishing) {
            return;
        }
        PageReference pageReference = new PageReference(page, this.buffers.size());
        for (Queue<PageReference> buffer : this.buffers) {
            buffer.add(pageReference);
        }
        this.bufferBytes += page.getSizeInBytes();
        this.notifyBlockedReaders();
    }

    private synchronized void notifyBlockedReaders() {
        if (this.readerFuture != null) {
            this.readerFuture.set(null);
            this.readerFuture = null;
        }
    }

    public synchronized ListenableFuture<?> waitForReading(int bufferIndex) {
        if (this.finishing || !this.buffers.get(bufferIndex).isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        if (this.readerFuture == null) {
            this.readerFuture = SettableFuture.create();
        }
        return this.readerFuture;
    }

    public synchronized Page removePage(int bufferIndex) {
        PageReference pageReference = this.buffers.get(bufferIndex).poll();
        if (pageReference == null) {
            return null;
        }
        Page page = pageReference.removePage();
        if (!pageReference.isReferenced()) {
            this.bufferBytes -= page.getSizeInBytes();
            if (this.bufferBytes < this.maxBufferedBytes) {
                this.notifyBlockedWriters();
            }
        }
        return page;
    }

    private synchronized void notifyBlockedWriters() {
        if (this.writerFuture != null) {
            this.writerFuture.set(null);
            this.writerFuture = null;
        }
    }

    public synchronized ListenableFuture<?> waitForWriting() {
        if (this.bufferBytes < this.maxBufferedBytes) {
            return Operator.NOT_BLOCKED;
        }
        if (this.writerFuture == null) {
            this.writerFuture = SettableFuture.create();
        }
        return this.writerFuture;
    }

    private class InMemoryExchangeSinkOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private boolean closed;

        private InMemoryExchangeSinkOperatorFactory(int operatorId) {
            this.operatorId = operatorId;
        }

        @Override
        public List<Type> getTypes() {
            return InMemoryExchange.this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, InMemoryExchangeSinkOperator.class.getSimpleName());
            InMemoryExchange.this.addSink();
            return new InMemoryExchangeSinkOperator(operatorContext, InMemoryExchange.this);
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                InMemoryExchange.this.sinkFactoryClosed();
            }
        }
    }

    private static class PageReference {
        private final Page page;
        private int referenceCount;

        public PageReference(Page page, int referenceCount) {
            this.page = page;
            this.referenceCount = referenceCount;
        }

        public Page removePage() {
            Preconditions.checkArgument((this.referenceCount > 0 ? 1 : 0) != 0);
            --this.referenceCount;
            return this.page;
        }

        public boolean isReferenced() {
            return this.referenceCount > 0;
        }
    }
}

