/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ChannelSet;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.MoreFutures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class HashSemiJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int probeJoinChannel;
    private final List<Type> types;
    private final ListenableFuture<ChannelSet> channelSetFuture;
    private ChannelSet channelSet;
    private Page outputPage;
    private boolean finishing;

    public HashSemiJoinOperator(OperatorContext operatorContext, SetBuilderOperator.SetSupplier channelSetFuture, List<Type> probeTypes, int probeJoinChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)channelSetFuture, (Object)"hashProvider is null");
        Preconditions.checkNotNull(probeTypes, (Object)"probeTypes is null");
        Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
        this.channelSetFuture = channelSetFuture.getChannelSet();
        this.probeJoinChannel = probeJoinChannel;
        this.types = ImmutableList.builder().addAll(probeTypes).add((Object)BooleanType.BOOLEAN).build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.channelSetFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing || this.outputPage != null) {
            return false;
        }
        if (this.channelSet == null) {
            this.channelSet = MoreFutures.tryGetUnchecked(this.channelSetFuture);
        }
        return this.channelSet != null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.channelSet != null ? 1 : 0) != 0, (Object)"Set has not been built yet");
        Preconditions.checkState((this.outputPage == null ? 1 : 0) != 0, (Object)"Operator still has pending output");
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(page.getPositionCount());
        Page probeJoinPage = new Page(new Block[]{page.getBlock(this.probeJoinChannel)});
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (probeJoinPage.getBlock(0).isNull(position)) {
                blockBuilder.appendNull();
                continue;
            }
            boolean contains = this.channelSet.contains(position, probeJoinPage);
            if (!contains && this.channelSet.containsNull()) {
                blockBuilder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, contains);
        }
        Block[] sourceBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[sourceBlocks.length + 1];
        System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
        outputBlocks[sourceBlocks.length] = blockBuilder.build();
        this.outputPage = new Page(outputBlocks);
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class HashSemiJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SetBuilderOperator.SetSupplier setSupplier;
        private final List<Type> probeTypes;
        private final int probeJoinChannel;
        private final List<Type> types;
        private boolean closed;

        public HashSemiJoinOperatorFactory(int operatorId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel) {
            this.operatorId = operatorId;
            this.setSupplier = setSupplier;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.probeJoinChannel = probeJoinChannel;
            this.types = ImmutableList.builder().addAll(probeTypes).add((Object)BooleanType.BOOLEAN).build();
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashSemiJoinOperator(operatorContext, this.setSupplier, this.probeTypes, this.probeJoinChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

