/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class DeleteOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    private final int rowIdChannel;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;
    private Supplier<Optional<UpdatablePageSource>> pageSource = Optional::empty;

    public DeleteOperator(OperatorContext operatorContext, int rowIdChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.rowIdChannel = rowIdChannel;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object[])new Object[]{this.state});
        Block rowIds = page.getBlock(this.rowIdChannel);
        this.pageSource().deleteRows(rowIds);
        this.rowCount += (long)rowIds.getPositionCount();
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = this.pageSource().commit();
        this.committed = true;
        PageBuilder page = new PageBuilder(TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                this.pageSource.get().ifPresent(UpdatablePageSource::rollback);
            }
        }
    }

    public void setPageSource(Supplier<Optional<UpdatablePageSource>> pageSource) {
        this.pageSource = (Supplier)Preconditions.checkNotNull(pageSource, (Object)"pageSource is null");
    }

    private UpdatablePageSource pageSource() {
        Optional<UpdatablePageSource> source = this.pageSource.get();
        Preconditions.checkState((boolean)source.isPresent(), (Object)"UpdatablePageSource not set");
        return source.get();
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class DeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final int rowIdChannel;
        private boolean closed;

        public DeleteOperatorFactory(int operatorId, int rowIdChannel) {
            this.operatorId = operatorId;
            this.rowIdChannel = rowIdChannel;
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, DeleteOperator.class.getSimpleName());
            return new DeleteOperator(context, this.rowIdChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

