/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TableLayout {
    private final TableLayoutHandle handle;
    private final ConnectorTableLayout layout;

    public TableLayout(TableLayoutHandle handle, ConnectorTableLayout layout) {
        Preconditions.checkNotNull((Object)handle, (Object)"handle is null");
        Preconditions.checkNotNull((Object)layout, (Object)"layout is null");
        this.handle = handle;
        this.layout = layout;
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.layout.getColumns();
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.layout.getPredicate();
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.layout.getLocalProperties();
    }

    public TableLayoutHandle getHandle() {
        return this.handle;
    }

    public Optional<Set<ColumnHandle>> getPartitioningColumns() {
        return this.layout.getPartitioningColumns();
    }

    public Optional<List<TupleDomain<ColumnHandle>>> getDiscretePredicates() {
        return this.layout.getDiscretePredicates();
    }

    public static TableLayout fromConnectorLayout(String connectorId, ConnectorTableLayout layout) {
        return new TableLayout(new TableLayoutHandle(connectorId, layout.getHandle()), layout);
    }
}

