/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.LegacyTableLayoutHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;

public class MetadataManager
implements Metadata {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final ConcurrentMap<String, ConnectorMetadataEntry> informationSchemasByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> systemTablesByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectorsByCatalog = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final ConcurrentMap<String, ConnectorMetadataEntry> connectorsById = new ConcurrentHashMap<String, ConnectorMetadataEntry>();
    private final FunctionRegistry functions;
    private final TypeManager typeManager;
    private final JsonCodec<ViewDefinition> viewCodec;
    private final SplitManager splitManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final SessionPropertyManager sessionPropertyManager;
    private final TablePropertyManager tablePropertyManager;

    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, SplitManager splitManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager) {
        this(featuresConfig, typeManager, MetadataManager.createTestingViewCodec(), splitManager, blockEncodingSerde, sessionPropertyManager, tablePropertyManager);
    }

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, TypeManager typeManager, JsonCodec<ViewDefinition> viewCodec, SplitManager splitManager, BlockEncodingSerde blockEncodingSerde, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager) {
        this.functions = new FunctionRegistry(typeManager, blockEncodingSerde, featuresConfig.isExperimentalSyntaxEnabled());
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"types is null");
        this.viewCodec = (JsonCodec)Preconditions.checkNotNull(viewCodec, (Object)"viewCodec is null");
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.blockEncodingSerde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)blockEncodingSerde, (Object)"blockEncodingSerde is null");
        this.sessionPropertyManager = (SessionPropertyManager)Preconditions.checkNotNull((Object)sessionPropertyManager, (Object)"sessionPropertyManager is null");
        this.tablePropertyManager = (TablePropertyManager)Preconditions.checkNotNull((Object)tablePropertyManager, (Object)"tablePropertyManager is null");
    }

    public static MetadataManager createTestMetadataManager() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        TypeRegistry typeManager = new TypeRegistry();
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager();
        SplitManager splitManager = new SplitManager();
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager((TypeManager)typeManager, new BlockEncodingFactory[0]);
        return new MetadataManager(featuresConfig, typeManager, splitManager, blockEncodingSerde, sessionPropertyManager, new TablePropertyManager());
    }

    public synchronized void addConnectorMetadata(String connectorId, String catalogName, ConnectorMetadata connectorMetadata) {
        this.checkMetadataArguments(connectorId, catalogName, connectorMetadata);
        Preconditions.checkArgument((!this.connectorsByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, connectorMetadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.connectorsByCatalog.put(catalogName, connectorMetadataEntry);
    }

    public synchronized void addInformationSchemaMetadata(String connectorId, String catalogName, InformationSchemaMetadata metadata) {
        this.checkMetadataArguments(connectorId, catalogName, (ConnectorMetadata)metadata);
        Preconditions.checkArgument((!this.informationSchemasByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"Information schema for catalog '%s' is already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, (ConnectorMetadata)metadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.informationSchemasByCatalog.put(catalogName, connectorMetadataEntry);
    }

    public synchronized void addSystemTablesMetadata(String connectorId, String catalogName, ConnectorMetadata metadata) {
        this.checkMetadataArguments(connectorId, catalogName, metadata);
        Preconditions.checkArgument((!this.systemTablesByCatalog.containsKey(catalogName) ? 1 : 0) != 0, (String)"System tables for catalog '%s' are already registered", (Object[])new Object[]{catalogName});
        ConnectorMetadataEntry connectorMetadataEntry = new ConnectorMetadataEntry(connectorId, catalogName, metadata);
        this.connectorsById.put(connectorId, connectorMetadataEntry);
        this.systemTablesByCatalog.put(catalogName, connectorMetadataEntry);
    }

    private void checkMetadataArguments(String connectorId, String catalogName, ConnectorMetadata metadata) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkArgument((!this.connectorsById.containsKey(connectorId) ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeManager.getType(signature);
    }

    @Override
    public FunctionInfo resolveFunction(QualifiedName name, List<TypeSignature> parameterTypes, boolean approximate) {
        return this.functions.resolveFunction(name, parameterTypes, approximate);
    }

    @Override
    public FunctionInfo getExactFunction(Signature handle) {
        return this.functions.getExactFunction(handle);
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.isAggregationFunction(name);
    }

    @Override
    public List<ParametricFunction> listFunctions() {
        return this.functions.list();
    }

    @Override
    public void addFunctions(List<? extends ParametricFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public FunctionInfo resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.functions.resolveOperator(operatorType, argumentTypes);
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        MetadataUtil.checkCatalogName(catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(catalogName)) {
            schemaNames.addAll((Iterable)entry.getMetadata().listSchemaNames(session.toConnectorSession(entry.getCatalog())));
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedTableName table) {
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        ConnectorMetadataEntry entry = this.getConnectorFor(table);
        if (entry != null && (tableHandle = (metadata = entry.getMetadata()).getTableHandle(session.toConnectorSession(entry.getCatalog()), table.asSchemaTableName())) != null) {
            return Optional.of(new TableHandle(entry.getConnectorId(), tableHandle));
        }
        return Optional.empty();
    }

    @Override
    public List<TableLayoutResult> getLayouts(Session session, TableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        List layouts;
        if (constraint.getSummary().isNone()) {
            return ImmutableList.of();
        }
        TupleDomain summary = constraint.getSummary();
        String connectorId = table.getConnectorId();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        Predicate predicate = constraint.predicate();
        ConnectorMetadataEntry entry = this.getConnectorMetadata(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
        try {
            layouts = entry.getMetadata().getTableLayouts(connectorSession, connectorTable, new Constraint(summary, predicate::test), desiredColumns);
        }
        catch (UnsupportedOperationException e) {
            ConnectorSplitManager connectorSplitManager = this.splitManager.getConnectorSplitManager(connectorId);
            ConnectorPartitionResult result = connectorSplitManager.getPartitions(connectorSession, connectorTable, summary);
            List partitions = (List)result.getPartitions().stream().filter(partition -> predicate.test(partition.getTupleDomain().extractFixedValues())).collect(ImmutableCollectors.toImmutableList());
            List partitionDomains = (List)partitions.stream().map(ConnectorPartition::getTupleDomain).collect(ImmutableCollectors.toImmutableList());
            TupleDomain effectivePredicate = TupleDomain.none();
            if (!partitionDomains.isEmpty()) {
                effectivePredicate = TupleDomain.columnWiseUnion((List)partitionDomains);
            }
            ConnectorTableLayout layout2 = new ConnectorTableLayout((ConnectorTableLayoutHandle)new LegacyTableLayoutHandle(connectorTable, partitions), Optional.empty(), effectivePredicate, Optional.empty(), Optional.of(partitionDomains), (List)ImmutableList.of());
            layouts = ImmutableList.of((Object)new ConnectorTableLayoutResult(layout2, result.getUndeterminedTupleDomain()));
        }
        return (List)layouts.stream().map(layout -> new TableLayoutResult(TableLayout.fromConnectorLayout(connectorId, layout.getTableLayout()), (TupleDomain<ColumnHandle>)layout.getUnenforcedConstraint())).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public TableLayout getLayout(Session session, TableLayoutHandle handle) {
        if (handle.getConnectorHandle() instanceof LegacyTableLayoutHandle) {
            LegacyTableLayoutHandle legacyHandle = (LegacyTableLayoutHandle)handle.getConnectorHandle();
            List partitionDomains = (List)legacyHandle.getPartitions().stream().map(ConnectorPartition::getTupleDomain).collect(ImmutableCollectors.toImmutableList());
            TupleDomain predicate = TupleDomain.none();
            if (!partitionDomains.isEmpty()) {
                predicate = TupleDomain.columnWiseUnion((List)partitionDomains);
            }
            return new TableLayout(handle, new ConnectorTableLayout((ConnectorTableLayoutHandle)legacyHandle, Optional.empty(), predicate, Optional.empty(), Optional.of(partitionDomains), (List)ImmutableList.of()));
        }
        String connectorId = handle.getConnectorId();
        ConnectorMetadataEntry entry = this.getConnectorMetadata(connectorId);
        return TableLayout.fromConnectorLayout(connectorId, entry.getMetadata().getTableLayout(session.toConnectorSession(entry.getCatalog()), handle.getConnectorHandle()));
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorTableMetadata tableMetadata = entry.getMetadata().getTableMetadata(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new TableMetadata(tableHandle.getConnectorId(), tableMetadata);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getColumnHandles(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getColumnMetadata(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedTableName> listTables(Session session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedTableName> tables = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
            for (QualifiedTableName tableName : Iterables.transform((Iterable)entry.getMetadata().listTables(connectorSession, schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                tables.add(tableName);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Optional<ColumnHandle> getSampleWeightColumnHandle(Session session, TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ColumnHandle handle = entry.getMetadata().getSampleWeightColumnHandle(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return Optional.ofNullable(handle);
    }

    @Override
    public boolean canCreateSampledTables(Session session, String catalogName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        return connectorMetadata.getMetadata().canCreateSampledTables(session.toConnectorSession(connectorMetadata.getCatalog()));
    }

    @Override
    public Map<QualifiedTableName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        HashMap tableColumns = new HashMap();
        for (ConnectorMetadataEntry connectorMetadata : this.allConnectorsFor(prefix.getCatalogName())) {
            QualifiedTableName tableName;
            ConnectorMetadata metadata = connectorMetadata.getMetadata();
            ConnectorSession connectorSession = session.toConnectorSession(connectorMetadata.getCatalog());
            for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                tableColumns.put(tableName, entry.getValue());
            }
            for (Map.Entry entry : metadata.getViews(connectorSession, tablePrefix).entrySet()) {
                tableName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                ImmutableList.Builder columns = ImmutableList.builder();
                for (ViewDefinition.ViewColumn column : this.deserializeView((String)entry.getValue()).getColumns()) {
                    columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), false));
                }
                tableColumns.put(tableName, columns.build());
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createTable(Session session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        connectorMetadata.getMetadata().createTable(session.toConnectorSession(connectorMetadata.getCatalog()), tableMetadata.getMetadata());
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedTableName newTableName) {
        String catalogName = newTableName.getCatalogName();
        ConnectorMetadataEntry target = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        if (target == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Target catalog '%s' does not exist", catalogName));
        }
        if (!tableHandle.getConnectorId().equals(target.getConnectorId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().renameTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().renameColumn(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().dropTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, TableMetadata tableMetadata) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName);
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{catalogName});
        ConnectorSession connectorSession = session.toConnectorSession(connectorMetadata.getCatalog());
        ConnectorOutputTableHandle handle = connectorMetadata.getMetadata().beginCreateTable(connectorSession, tableMetadata.getMetadata());
        return new OutputTableHandle(connectorMetadata.getConnectorId(), handle);
    }

    @Override
    public void commitCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitCreateTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackCreateTable(Session session, OutputTableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackCreateTable(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorInsertTableHandle handle = entry.getMetadata().beginInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new InsertTableHandle(tableHandle.getConnectorId(), handle);
    }

    @Override
    public void commitInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackInsert(Session session, InsertTableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackInsert(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        return entry.getMetadata().getUpdateRowIdColumnHandle(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        ConnectorTableHandle newHandle = entry.getMetadata().beginDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getConnectorId(), newHandle);
    }

    @Override
    public void commitDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().commitDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public void rollbackDelete(Session session, TableHandle tableHandle) {
        ConnectorMetadataEntry entry = this.lookupConnectorFor(tableHandle);
        entry.getMetadata().rollbackDelete(session.toConnectorSession(entry.getCatalog()), tableHandle.getConnectorHandle());
    }

    @Override
    public Map<String, String> getCatalogNames() {
        ImmutableMap.Builder catalogsMap = ImmutableMap.builder();
        for (Map.Entry entry : this.connectorsByCatalog.entrySet()) {
            catalogsMap.put(entry.getKey(), (Object)((ConnectorMetadataEntry)entry.getValue()).getConnectorId());
        }
        return catalogsMap.build();
    }

    @Override
    public List<QualifiedTableName> listViews(Session session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        String schemaNameOrNull = prefix.getSchemaName().orElse(null);
        LinkedHashSet<QualifiedTableName> views = new LinkedHashSet<QualifiedTableName>();
        for (ConnectorMetadataEntry entry : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(entry.getCatalog());
            for (QualifiedTableName tableName : Iterables.transform((Iterable)entry.getMetadata().listViews(connectorSession, schemaNameOrNull), QualifiedTableName.convertFromSchemaTableName(prefix.getCatalogName()))) {
                views.add(tableName);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedTableName, ViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
        LinkedHashMap<QualifiedTableName, ViewDefinition> views = new LinkedHashMap<QualifiedTableName, ViewDefinition>();
        for (ConnectorMetadataEntry metadata : this.allConnectorsFor(prefix.getCatalogName())) {
            ConnectorSession connectorSession = session.toConnectorSession(metadata.getCatalog());
            for (Map.Entry entry : metadata.getMetadata().getViews(connectorSession, tablePrefix).entrySet()) {
                QualifiedTableName viewName = new QualifiedTableName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                views.put(viewName, this.deserializeView((String)entry.getValue()));
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedTableName viewName) {
        ConnectorMetadataEntry entry = this.getConnectorFor(viewName);
        if (entry != null) {
            SchemaTablePrefix prefix = viewName.asSchemaTableName().toSchemaTablePrefix();
            Map views = entry.getMetadata().getViews(session.toConnectorSession(entry.getCatalog()), prefix);
            String view = (String)views.get(viewName.asSchemaTableName());
            if (view != null) {
                return Optional.of(this.deserializeView(view));
            }
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedTableName viewName, String viewData, boolean replace) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().createView(session.toConnectorSession(connectorMetadata.getCatalog()), viewName.asSchemaTableName(), viewData, replace);
    }

    @Override
    public void dropView(Session session, QualifiedTableName viewName) {
        ConnectorMetadataEntry connectorMetadata = (ConnectorMetadataEntry)this.connectorsByCatalog.get(viewName.getCatalogName());
        Preconditions.checkArgument((connectorMetadata != null ? 1 : 0) != 0, (String)"Catalog %s does not exist", (Object[])new Object[]{viewName.getCatalogName()});
        connectorMetadata.getMetadata().dropView(session.toConnectorSession(connectorMetadata.getCatalog()), viewName.asSchemaTableName());
    }

    @Override
    public FunctionRegistry getFunctionRegistry() {
        return this.functions;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return this.blockEncodingSerde;
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    private ViewDefinition deserializeView(String data) {
        try {
            return (ViewDefinition)this.viewCodec.fromJson(data);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Invalid view JSON: " + data, (Throwable)e);
        }
    }

    private List<ConnectorMetadataEntry> allConnectorsFor(String catalogName) {
        ConnectorMetadataEntry connector;
        ConnectorMetadataEntry systemTables;
        ImmutableList.Builder builder = ImmutableList.builder();
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.informationSchemasByCatalog.get(catalogName);
        if (entry != null) {
            builder.add((Object)entry);
        }
        if ((systemTables = (ConnectorMetadataEntry)this.systemTablesByCatalog.get(catalogName)) != null) {
            builder.add((Object)systemTables);
        }
        if ((connector = (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalogName)) != null) {
            builder.add((Object)connector);
        }
        return builder.build();
    }

    private ConnectorMetadataEntry getConnectorFor(QualifiedTableName name) {
        String catalog = name.getCatalogName();
        String schema = name.getSchemaName();
        if (schema.equals(INFORMATION_SCHEMA_NAME)) {
            return (ConnectorMetadataEntry)this.informationSchemasByCatalog.get(catalog);
        }
        ConnectorMetadataEntry entry = (ConnectorMetadataEntry)this.systemTablesByCatalog.get(catalog);
        if (entry != null && entry.getMetadata().getTableHandle(null, name.asSchemaTableName()) != null) {
            return entry;
        }
        return (ConnectorMetadataEntry)this.connectorsByCatalog.get(catalog);
    }

    private ConnectorMetadataEntry lookupConnectorFor(TableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry lookupConnectorFor(OutputTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry lookupConnectorFor(InsertTableHandle tableHandle) {
        return this.getConnectorMetadata(tableHandle.getConnectorId());
    }

    private ConnectorMetadataEntry getConnectorMetadata(String connectorId) {
        ConnectorMetadataEntry result = (ConnectorMetadataEntry)this.connectorsById.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No connector for connector ID: %s", (Object[])new Object[]{connectorId});
        return result;
    }

    private static JsonCodec<ViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(new TypeRegistry()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ViewDefinition.class);
    }

    private static class ConnectorMetadataEntry {
        private final String connectorId;
        private final String catalog;
        private final ConnectorMetadata metadata;

        private ConnectorMetadataEntry(String connectorId, String catalog, ConnectorMetadata metadata) {
            this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
            this.catalog = (String)Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
            this.metadata = (ConnectorMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        }

        private String getConnectorId() {
            return this.connectorId;
        }

        private String getCatalog() {
            return this.catalog;
        }

        private ConnectorMetadata getMetadata() {
            return this.metadata;
        }
    }
}

