/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.window.AggregateWindowFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FunctionInfo
implements ParametricFunction {
    private final Signature signature;
    private final String description;
    private final boolean hidden;
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final boolean isAggregate;
    private final TypeSignature intermediateType;
    private final InternalAggregationFunction aggregationFunction;
    private final boolean isApproximate;
    private final MethodHandle methodHandle;
    private final boolean deterministic;
    private final boolean isWindow;
    private final WindowFunctionSupplier windowFunctionSupplier;

    public FunctionInfo(Signature signature, String description, WindowFunctionSupplier windowFunctionSupplier) {
        this.signature = signature;
        this.description = description;
        this.hidden = false;
        this.deterministic = true;
        this.nullable = false;
        this.nullableArguments = ImmutableList.copyOf(Collections.nCopies(signature.getArgumentTypes().size(), false));
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.isApproximate = false;
        this.methodHandle = null;
        this.isWindow = true;
        this.windowFunctionSupplier = (WindowFunctionSupplier)Preconditions.checkNotNull((Object)windowFunctionSupplier, (Object)"windowFunction is null");
    }

    public FunctionInfo(Signature signature, String description, InternalAggregationFunction function) {
        this.signature = signature;
        this.description = description;
        this.isApproximate = function.isApproximate();
        this.hidden = false;
        this.intermediateType = function.getIntermediateType().getTypeSignature();
        this.aggregationFunction = function;
        this.isAggregate = true;
        this.methodHandle = null;
        this.deterministic = true;
        this.nullable = false;
        this.nullableArguments = ImmutableList.copyOf(Collections.nCopies(signature.getArgumentTypes().size(), false));
        this.isWindow = true;
        this.windowFunctionSupplier = AggregateWindowFunction.supplier(signature, function);
    }

    public FunctionInfo(Signature signature, String description, boolean hidden, MethodHandle function, boolean deterministic, boolean nullableResult, List<Boolean> nullableArguments) {
        this.signature = signature;
        this.description = description;
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.nullable = nullableResult;
        this.nullableArguments = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(nullableArguments, (Object)"nullableArguments is null")));
        Preconditions.checkArgument((nullableArguments.size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)String.format("nullableArguments size (%d) does not match signature %s", nullableArguments.size(), signature));
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.isApproximate = false;
        this.isWindow = false;
        this.windowFunctionSupplier = null;
        this.methodHandle = (MethodHandle)Preconditions.checkNotNull((Object)function, (Object)"function is null");
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public QualifiedName getName() {
        return QualifiedName.of((String)this.signature.getName(), (String[])new String[0]);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public boolean isWindow() {
        return this.isWindow;
    }

    @Override
    public boolean isScalar() {
        return !this.isWindow && !this.isAggregate;
    }

    @Override
    public boolean isUnbound() {
        return false;
    }

    @Override
    public boolean isApproximate() {
        return this.isApproximate;
    }

    public TypeSignature getReturnType() {
        return this.signature.getReturnType();
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public TypeSignature getIntermediateType() {
        return this.intermediateType;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        return this;
    }

    public WindowFunctionDefinition bindWindowFunction(Type type, List<Integer> inputs) {
        Preconditions.checkState((boolean)this.isWindow, (Object)"not a window function");
        return WindowFunctionDefinition.window(this.windowFunctionSupplier, type, inputs);
    }

    public InternalAggregationFunction getAggregationFunction() {
        Preconditions.checkState((this.aggregationFunction != null ? 1 : 0) != 0, (Object)"not an aggregation function");
        return this.aggregationFunction;
    }

    public MethodHandle getMethodHandle() {
        Preconditions.checkState((this.methodHandle != null ? 1 : 0) != 0, (Object)"not a scalar function or operator");
        return this.methodHandle;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionInfo other = (FunctionInfo)obj;
        return Objects.equals(this.signature, other.signature) && Objects.equals(this.isAggregate, other.isAggregate) && Objects.equals(this.isWindow, other.isWindow);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.isAggregate, this.isWindow);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("signature", (Object)this.signature).add("isAggregate", this.isAggregate).add("isWindow", this.isWindow).toString();
    }
}

