/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class QueryContext {
    private final long maxMemory;
    private final boolean enforceLimit;
    private final Executor executor;
    private final List<TaskContext> taskContexts = new CopyOnWriteArrayList<TaskContext>();
    private final MemoryPool systemMemoryPool;
    @GuardedBy(value="this")
    private long reserved;
    @GuardedBy(value="this")
    private MemoryPool memoryPool;
    @GuardedBy(value="this")
    private long systemReserved;

    public QueryContext(boolean enforceLimit, DataSize maxMemory, MemoryPool memoryPool, MemoryPool systemMemoryPool, Executor executor) {
        this.enforceLimit = enforceLimit;
        this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null").toBytes();
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.systemMemoryPool = Objects.requireNonNull(systemMemoryPool, "systemMemoryPool is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public synchronized ListenableFuture<?> reserveMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.reserved + bytes > this.maxMemory && this.enforceLimit) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_MEMORY_LIMIT, "Query exceeded local memory limit of " + new DataSize((double)this.maxMemory, DataSize.Unit.BYTE).convertToMostSuccinctDataSize());
        }
        ListenableFuture<?> future = this.memoryPool.reserve(bytes);
        this.reserved += bytes;
        return future;
    }

    public synchronized ListenableFuture<?> reserveSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        ListenableFuture<?> future = this.systemMemoryPool.reserve(bytes);
        this.systemReserved += bytes;
        return future;
    }

    public synchronized boolean tryReserveMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.reserved + bytes > this.maxMemory && this.enforceLimit) {
            return false;
        }
        if (this.memoryPool.tryReserve(bytes)) {
            this.reserved += bytes;
            return true;
        }
        return false;
    }

    public synchronized void freeMemory(long bytes) {
        Preconditions.checkArgument((this.reserved - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.reserved -= bytes;
        this.memoryPool.free(bytes);
    }

    public synchronized void freeSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.systemReserved - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more system memory than is reserved");
        this.systemReserved -= bytes;
        this.systemMemoryPool.free(bytes);
    }

    public synchronized void setMemoryPool(MemoryPool pool) {
        Objects.requireNonNull(pool, "pool is null");
        if (pool.getId().equals(this.memoryPool.getId())) {
            return;
        }
        final MemoryPool originalPool = this.memoryPool;
        final long originalReserved = this.reserved;
        this.memoryPool = pool;
        ListenableFuture<?> future = pool.reserve(this.reserved);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                originalPool.free(originalReserved);
                QueryContext.this.taskContexts.stream().forEach(TaskContext::moreMemoryAvailable);
            }

            public void onFailure(Throwable t) {
                originalPool.free(originalReserved);
                QueryContext.this.taskContexts.stream().forEach(TaskContext::moreMemoryAvailable);
            }
        });
    }

    public TaskContext addTaskContext(TaskStateMachine taskStateMachine, Session session, DataSize maxTaskMemory, DataSize operatorPreAllocatedMemory, boolean verboseStats, boolean cpuTimerEnabled) {
        TaskContext taskContext = new TaskContext(this, taskStateMachine, this.executor, session, maxTaskMemory, operatorPreAllocatedMemory, verboseStats, cpuTimerEnabled);
        this.taskContexts.add(taskContext);
        return taskContext;
    }
}

