/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.MemoryPoolId;
import com.facebook.presto.memory.MemoryPoolInfo;
import com.facebook.presto.operator.Operator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class MemoryPool {
    private final MemoryPoolId id;
    private final long maxBytes;
    private final boolean enableBlocking;
    @GuardedBy(value="this")
    private long freeBytes;
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<?> future;

    public MemoryPool(MemoryPoolId id, DataSize size, boolean enableBlocking) {
        this.id = Objects.requireNonNull(id, "name is null");
        Objects.requireNonNull(size, "size is null");
        this.maxBytes = size.toBytes();
        this.enableBlocking = enableBlocking;
        this.freeBytes = size.toBytes();
    }

    public MemoryPoolId getId() {
        return this.id;
    }

    public synchronized MemoryPoolInfo getInfo() {
        return new MemoryPoolInfo(this.maxBytes, this.freeBytes);
    }

    public synchronized ListenableFuture<?> reserve(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.freeBytes -= bytes;
        if (this.freeBytes <= 0L) {
            if (this.future == null) {
                this.future = SettableFuture.create();
            }
            Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
            if (this.enableBlocking) {
                return this.future;
            }
        }
        return Operator.NOT_BLOCKED;
    }

    public synchronized boolean tryReserve(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.freeBytes - bytes < 0L) {
            return false;
        }
        this.freeBytes -= bytes;
        return true;
    }

    public synchronized void free(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.freeBytes + bytes <= this.maxBytes ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.freeBytes += bytes;
        if (this.freeBytes > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    @Managed
    public synchronized long getFreeBytes() {
        return this.freeBytes;
    }

    @Managed
    public synchronized long getMaxBytes() {
        return this.maxBytes;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("maxBytes", this.maxBytes).add("enableBlocking", this.enableBlocking).add("freeBytes", this.freeBytes).add("future", this.future).toString();
    }
}

