/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.MemoryPoolId;
import com.facebook.presto.memory.MemoryPoolInfo;
import com.facebook.presto.memory.ReservedSystemMemoryConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public final class LocalMemoryManager {
    public static final MemoryPoolId GENERAL_POOL = new MemoryPoolId("general");
    public static final MemoryPoolId RESERVED_POOL = new MemoryPoolId("reserved");
    public static final MemoryPoolId SYSTEM_POOL = new MemoryPoolId("system");
    private final DataSize maxMemory;
    private final Map<MemoryPoolId, MemoryPool> pools;

    @Inject
    public LocalMemoryManager(MemoryManagerConfig config, ReservedSystemMemoryConfig systemMemoryConfig) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(systemMemoryConfig, "systemMemoryConfig is null");
        long maxHeap = Runtime.getRuntime().maxMemory();
        Preconditions.checkArgument((systemMemoryConfig.getReservedSystemMemory().toBytes() < maxHeap ? 1 : 0) != 0, (String)"Reserved memory %s is greater than available heap %s", (Object[])new Object[]{systemMemoryConfig.getReservedSystemMemory(), new DataSize((double)maxHeap, DataSize.Unit.BYTE)});
        this.maxMemory = new DataSize((double)(maxHeap - systemMemoryConfig.getReservedSystemMemory().toBytes()), DataSize.Unit.BYTE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Preconditions.checkArgument((config.getMaxQueryMemoryPerNode().toBytes() < this.maxMemory.toBytes() ? 1 : 0) != 0, (Object)String.format("%s set to %s, but only %s of useable heap available", "query.max-memory-per-node", config.getMaxQueryMemoryPerNode(), this.maxMemory));
        builder.put((Object)RESERVED_POOL, (Object)new MemoryPool(RESERVED_POOL, config.getMaxQueryMemoryPerNode(), config.isClusterMemoryManagerEnabled()));
        DataSize generalPoolSize = new DataSize((double)Math.max(0L, this.maxMemory.toBytes() - config.getMaxQueryMemoryPerNode().toBytes()), DataSize.Unit.BYTE);
        builder.put((Object)GENERAL_POOL, (Object)new MemoryPool(GENERAL_POOL, generalPoolSize, config.isClusterMemoryManagerEnabled()));
        builder.put((Object)SYSTEM_POOL, (Object)new MemoryPool(SYSTEM_POOL, systemMemoryConfig.getReservedSystemMemory(), config.isClusterMemoryManagerEnabled()));
        this.pools = builder.build();
    }

    public MemoryInfo getInfo() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MemoryPoolId, MemoryPool> entry : this.pools.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getInfo());
        }
        return new MemoryInfo(this.maxMemory, (Map<MemoryPoolId, MemoryPoolInfo>)builder.build());
    }

    public List<MemoryPool> getPools() {
        return ImmutableList.copyOf(this.pools.values());
    }

    public MemoryPool getPool(MemoryPoolId id) {
        return this.pools.get(id);
    }
}

