/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.big-query-max-task-memory"})
public class TaskManagerConfig {
    private boolean verboseStats;
    private boolean taskCpuTimerEnabled = true;
    private DataSize maxTaskMemoryUsage = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private DataSize maxPartialAggregationMemoryUsage = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize operatorPreAllocatedMemory = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize maxTaskIndexMemoryUsage = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 4;
    private Integer minDrivers;
    private DataSize sinkMaxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private Duration clientTimeout = new Duration(2.0, TimeUnit.MINUTES);
    private Duration infoMaxAge = new Duration(15.0, TimeUnit.MINUTES);
    private Duration infoRefreshMaxWait = new Duration(200.0, TimeUnit.MILLISECONDS);
    private int writerCount = 1;
    private int taskDefaultConcurrency = 1;
    private int httpNotificationThreads = 25;

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public Duration getInfoRefreshMaxWait() {
        return this.infoRefreshMaxWait;
    }

    @Config(value="task.info-refresh-max-wait")
    public TaskManagerConfig setInfoRefreshMaxWait(Duration infoRefreshMaxWait) {
        this.infoRefreshMaxWait = infoRefreshMaxWait;
        return this;
    }

    public boolean isVerboseStats() {
        return this.verboseStats;
    }

    @Config(value="task.verbose-stats")
    public TaskManagerConfig setVerboseStats(boolean verboseStats) {
        this.verboseStats = verboseStats;
        return this;
    }

    public boolean isTaskCpuTimerEnabled() {
        return this.taskCpuTimerEnabled;
    }

    @Config(value="task.cpu-timer-enabled")
    public TaskManagerConfig setTaskCpuTimerEnabled(boolean taskCpuTimerEnabled) {
        this.taskCpuTimerEnabled = taskCpuTimerEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialAggregationMemoryUsage() {
        return this.maxPartialAggregationMemoryUsage;
    }

    @Config(value="task.max-partial-aggregation-memory")
    public TaskManagerConfig setMaxPartialAggregationMemoryUsage(DataSize maxPartialAggregationMemoryUsage) {
        this.maxPartialAggregationMemoryUsage = maxPartialAggregationMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getMaxTaskMemoryUsage() {
        return this.maxTaskMemoryUsage;
    }

    @Config(value="task.max-memory")
    public TaskManagerConfig setMaxTaskMemoryUsage(DataSize maxTaskMemoryUsage) {
        this.maxTaskMemoryUsage = maxTaskMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getOperatorPreAllocatedMemory() {
        return this.operatorPreAllocatedMemory;
    }

    @Config(value="task.operator-pre-allocated-memory")
    public TaskManagerConfig setOperatorPreAllocatedMemory(DataSize operatorPreAllocatedMemory) {
        this.operatorPreAllocatedMemory = operatorPreAllocatedMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxTaskIndexMemoryUsage() {
        return this.maxTaskIndexMemoryUsage;
    }

    @Config(value="task.max-index-memory")
    public TaskManagerConfig setMaxTaskIndexMemoryUsage(DataSize maxTaskIndexMemoryUsage) {
        this.maxTaskIndexMemoryUsage = maxTaskIndexMemoryUsage;
        return this;
    }

    @Min(value=1L)
    public int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    @LegacyConfig(value={"task.shard.max-threads"})
    @Config(value="task.max-worker-threads")
    public TaskManagerConfig setMaxWorkerThreads(int maxWorkerThreads) {
        this.maxWorkerThreads = maxWorkerThreads;
        return this;
    }

    @Min(value=1L)
    public int getMinDrivers() {
        if (this.minDrivers == null) {
            return 2 * this.maxWorkerThreads;
        }
        return this.minDrivers;
    }

    @Config(value="task.min-drivers")
    public TaskManagerConfig setMinDrivers(int minDrivers) {
        this.minDrivers = minDrivers;
        return this;
    }

    @NotNull
    public DataSize getSinkMaxBufferSize() {
        return this.sinkMaxBufferSize;
    }

    @Config(value="sink.max-buffer-size")
    public TaskManagerConfig setSinkMaxBufferSize(DataSize sinkMaxBufferSize) {
        this.sinkMaxBufferSize = sinkMaxBufferSize;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="task.client.timeout")
    public TaskManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @NotNull
    public Duration getInfoMaxAge() {
        return this.infoMaxAge;
    }

    @Config(value="task.info.max-age")
    public TaskManagerConfig setInfoMaxAge(Duration infoMaxAge) {
        this.infoMaxAge = infoMaxAge;
        return this;
    }

    @Min(value=1L)
    public int getWriterCount() {
        return this.writerCount;
    }

    @Config(value="task.writer-count")
    @ConfigDescription(value="Number of writers per task")
    public TaskManagerConfig setWriterCount(int writerCount) {
        this.writerCount = writerCount;
        return this;
    }

    @Min(value=1L)
    public int getTaskDefaultConcurrency() {
        return this.taskDefaultConcurrency;
    }

    @Config(value="task.default-concurrency")
    @ConfigDescription(value="Default local concurrency for parallel operators")
    public TaskManagerConfig setTaskDefaultConcurrency(int taskDefaultConcurrency) {
        this.taskDefaultConcurrency = taskDefaultConcurrency;
        return this;
    }

    @Min(value=1L)
    public int getHttpNotificationThreads() {
        return this.httpNotificationThreads;
    }

    @Config(value="task.http-notification-threads")
    public TaskManagerConfig setHttpNotificationThreads(int httpNotificationThreads) {
        this.httpNotificationThreads = httpNotificationThreads;
        return this;
    }
}

