/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StateMachine<T> {
    private static final Logger log = Logger.get(StateMachine.class);
    private final String name;
    private final Executor executor;
    private final Object lock = new Object();
    private final Set<T> terminalStates;
    @GuardedBy(value="lock")
    private volatile T state;
    @GuardedBy(value="lock")
    private final List<StateChangeListener<T>> stateChangeListeners = new ArrayList<StateChangeListener<T>>();
    @GuardedBy(value="lock")
    private final Set<SettableFuture<T>> futureStateChanges = Sets.newIdentityHashSet();

    public StateMachine(String name, Executor executor, T initialState) {
        this(name, executor, initialState, (Iterable<T>)ImmutableSet.of());
    }

    public StateMachine(String name, Executor executor, T initialState, Iterable<T> terminalStates) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.state = Objects.requireNonNull(initialState, "initialState is null");
        this.terminalStates = ImmutableSet.copyOf(Objects.requireNonNull(terminalStates, "terminalStates is null"));
    }

    @Nonnull
    public T get() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public T set(T newState) {
        ImmutableList stateChangeListeners;
        ImmutableList futureStateChanges;
        T oldState;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.state.equals(newState)) {
                return this.state;
            }
            Preconditions.checkState((!this.isTerminalState(this.state) ? 1 : 0) != 0, (String)"%s can not transition from %s to %s", (Object[])new Object[]{this.name, this.state, newState});
            oldState = this.state;
            this.state = newState;
            futureStateChanges = ImmutableList.copyOf(this.futureStateChanges);
            this.futureStateChanges.clear();
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            if (this.isTerminalState(this.state)) {
                this.stateChangeListeners.clear();
            }
            this.lock.notifyAll();
        }
        this.fireStateChanged(newState, (List<SettableFuture<T>>)futureStateChanges, (List<StateChangeListener<T>>)stateChangeListeners);
        return oldState;
    }

    public boolean setIf(T newState, Predicate<T> predicate) {
        T currentState;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        do {
            if ((currentState = this.get()).equals(newState)) {
                return false;
            }
            if (predicate.apply(currentState)) continue;
            return false;
        } while (!this.compareAndSet(currentState, newState));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(T expectedState, T newState) {
        ImmutableList stateChangeListeners;
        ImmutableList futureStateChanges;
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not set state while holding the lock");
        Objects.requireNonNull(expectedState, "expectedState is null");
        Objects.requireNonNull(newState, "newState is null");
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.equals(expectedState)) {
                return false;
            }
            if (this.state.equals(newState)) {
                return false;
            }
            Preconditions.checkState((!this.isTerminalState(this.state) ? 1 : 0) != 0, (String)"%s can not transition from %s to %s", (Object[])new Object[]{this.name, this.state, newState});
            this.state = newState;
            futureStateChanges = ImmutableList.copyOf(this.futureStateChanges);
            this.futureStateChanges.clear();
            stateChangeListeners = ImmutableList.copyOf(this.stateChangeListeners);
            if (this.isTerminalState(this.state)) {
                this.stateChangeListeners.clear();
            }
            this.lock.notifyAll();
        }
        this.fireStateChanged(newState, (List<SettableFuture<T>>)futureStateChanges, (List<StateChangeListener<T>>)stateChangeListeners);
        return true;
    }

    private void fireStateChanged(T newState, List<SettableFuture<T>> futureStateChanges, List<StateChangeListener<T>> stateChangeListeners) {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not fire state change event while holding the lock");
        Objects.requireNonNull(newState, "newState is null");
        this.executor.execute(() -> {
            Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not notify while holding the lock");
            for (SettableFuture futureStateChange : futureStateChanges) {
                try {
                    futureStateChange.set(newState);
                }
                catch (Throwable e) {
                    log.error(e, "Error setting future state for %s", new Object[]{this.name});
                }
            }
            for (StateChangeListener stateChangeListener : stateChangeListeners) {
                try {
                    stateChangeListener.stateChanged(newState);
                }
                catch (Throwable e) {
                    log.error(e, "Error notifying state change listener for %s", new Object[]{this.name});
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> getStateChange(T currentState) {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not wait for state change while holding the lock");
        Objects.requireNonNull(currentState, "currentState is null");
        Object object = this.lock;
        synchronized (object) {
            if (!this.isPossibleStateChange(currentState)) {
                return Futures.immediateFuture(this.state);
            }
            final SettableFuture futureStateChange = SettableFuture.create();
            this.futureStateChanges.add(futureStateChange);
            Futures.addCallback((ListenableFuture)futureStateChange, (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable t) {
                    Object object = StateMachine.this.lock;
                    synchronized (object) {
                        StateMachine.this.futureStateChanges.remove(futureStateChange);
                    }
                }
            });
            return futureStateChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener<T> stateChangeListener) {
        boolean inTerminalState;
        Objects.requireNonNull(stateChangeListener, "stateChangeListener is null");
        Object object = this.lock;
        synchronized (object) {
            inTerminalState = this.isTerminalState(this.state);
            if (!inTerminalState) {
                this.stateChangeListeners.add(stateChangeListener);
            }
        }
        if (inTerminalState) {
            stateChangeListener.stateChanged(this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration waitForStateChange(T currentState, Duration maxWait) throws InterruptedException {
        Preconditions.checkState((!Thread.holdsLock(this.lock) ? 1 : 0) != 0, (Object)"Can not wait for state change while holding the lock");
        Objects.requireNonNull(currentState, "currentState is null");
        Objects.requireNonNull(maxWait, "maxWait is null");
        if (!this.isPossibleStateChange(currentState)) {
            return maxWait;
        }
        long remainingNanos = maxWait.roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        long end = start + remainingNanos;
        Object object = this.lock;
        synchronized (object) {
            while (remainingNanos > 0L && this.isPossibleStateChange(currentState)) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, remainingNanos);
                remainingNanos = end - System.nanoTime();
            }
        }
        if (remainingNanos < 0L) {
            remainingNanos = 0L;
        }
        return new Duration((double)remainingNanos, TimeUnit.NANOSECONDS);
    }

    private boolean isPossibleStateChange(T currentState) {
        return this.state.equals(currentState) && !this.isTerminalState(this.state);
    }

    @VisibleForTesting
    boolean isTerminalState(T state) {
        return this.terminalStates.contains(state);
    }

    @VisibleForTesting
    synchronized List<StateChangeListener<T>> getStateChangeListeners() {
        return ImmutableList.copyOf(this.stateChangeListeners);
    }

    @VisibleForTesting
    synchronized Set<SettableFuture<T>> getFutureStateChanges() {
        return ImmutableSet.copyOf(this.futureStateChanges);
    }

    public String toString() {
        return this.get().toString();
    }

    public static interface StateChangeListener<T> {
        public void stateChanged(T var1);
    }
}

