/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.HashPagePartitionFunction;
import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.PartitionedPagePartitionFunction;
import com.facebook.presto.Session;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStateMachine;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.HttpUriBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SqlStageExecution {
    private final PlanFragment fragment;
    private final Set<PlanNodeId> allSources;
    private final Map<PlanFragmentId, SqlStageExecution> subStages;
    private final Multimap<Node, TaskId> localNodeTaskMap = HashMultimap.create();
    private final ConcurrentMap<TaskId, RemoteTask> tasks = new ConcurrentHashMap<TaskId, RemoteTask>();
    private final Optional<SplitSource> dataSource;
    private final RemoteTaskFactory remoteTaskFactory;
    private final int splitBatchSize;
    private final int initialHashPartitions;
    private final StageStateMachine stateMachine;
    private final Set<PlanNodeId> completeSources = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private OutputBuffers currentOutputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS;
    @GuardedBy(value="this")
    private OutputBuffers nextOutputBuffers;
    private final ExecutorService executor;
    private final NodeScheduler.NodeSelector nodeSelector;
    private final NodeTaskMap nodeTaskMap;
    private final AtomicReference<Multimap<PlanNodeId, URI>> exchangeLocations = new AtomicReference<ImmutableMultimap>(ImmutableMultimap.of());

    public SqlStageExecution(QueryId queryId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int splitBatchSize, int initialHashPartitions, ExecutorService executor, NodeTaskMap nodeTaskMap, OutputBuffers nextOutputBuffers) {
        this(queryId, new AtomicInteger(), locationFactory, plan, nodeScheduler, remoteTaskFactory, session, splitBatchSize, initialHashPartitions, executor, nodeTaskMap);
        this.nextOutputBuffers = nextOutputBuffers;
    }

    private SqlStageExecution(QueryId queryId, AtomicInteger nextStageId, LocationFactory locationFactory, StageExecutionPlan plan, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, Session session, int splitBatchSize, int initialHashPartitions, ExecutorService executor, NodeTaskMap nodeTaskMap) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)nextStageId, (Object)"nextStageId is null");
        Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)nodeScheduler, (Object)"nodeScheduler is null");
        Preconditions.checkNotNull((Object)remoteTaskFactory, (Object)"remoteTaskFactory is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkArgument((initialHashPartitions > 0 ? 1 : 0) != 0, (Object)"initialHashPartitions must be greater than 0");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull((Object)nodeTaskMap, (Object)"nodeTaskMap is null");
        StageId stageId = new StageId(queryId, String.valueOf(nextStageId.getAndIncrement()));
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{stageId});){
            this.fragment = plan.getFragment();
            this.dataSource = plan.getDataSource();
            this.remoteTaskFactory = remoteTaskFactory;
            this.splitBatchSize = splitBatchSize;
            this.initialHashPartitions = initialHashPartitions;
            this.executor = executor;
            this.allSources = Stream.concat(Stream.of(plan.getFragment().getPartitionedSource()), plan.getFragment().getRemoteSourceNodes().stream().map(PlanNode::getId)).filter(Objects::nonNull).collect(Collectors.toSet());
            ImmutableMap.Builder subStages = ImmutableMap.builder();
            for (StageExecutionPlan subStagePlan : plan.getSubStages()) {
                PlanFragmentId subStageFragmentId = subStagePlan.getFragment().getId();
                SqlStageExecution subStage = new SqlStageExecution(queryId, nextStageId, locationFactory, subStagePlan, nodeScheduler, remoteTaskFactory, session, splitBatchSize, initialHashPartitions, executor, nodeTaskMap);
                subStages.put((Object)subStageFragmentId, (Object)subStage);
            }
            this.subStages = subStages.build();
            String dataSourceName = this.dataSource.isPresent() ? this.dataSource.get().getDataSourceName() : null;
            this.nodeSelector = nodeScheduler.createNodeSelector(dataSourceName);
            this.nodeTaskMap = nodeTaskMap;
            this.stateMachine = new StageStateMachine(stageId, locationFactory.createStageLocation(stageId), session, plan.getFragment(), executor);
        }
    }

    public void cancelStage(StageId stageId) {
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{stageId});){
            if (stageId.equals(this.stateMachine.getStageId())) {
                this.cancel();
            } else {
                for (SqlStageExecution subStage : this.subStages.values()) {
                    subStage.cancelStage(stageId);
                }
            }
        }
    }

    public StageState getState() {
        return this.stateMachine.getState();
    }

    public long getTotalMemoryReservation() {
        long memory = 0L;
        for (RemoteTask task : this.tasks.values()) {
            memory += task.getTaskInfo().getStats().getMemoryReservation().toBytes();
        }
        for (SqlStageExecution subStage : this.subStages.values()) {
            memory += subStage.getTotalMemoryReservation();
        }
        return memory;
    }

    public StageInfo getStageInfo() {
        return this.stateMachine.getStageInfo(() -> this.tasks.values().stream().map(RemoteTask::getTaskInfo).collect(ImmutableCollectors.toImmutableList()), () -> this.subStages.values().stream().map(SqlStageExecution::getStageInfo).collect(ImmutableCollectors.toImmutableList()));
    }

    public Collection<SqlStageExecution> getSubStages() {
        return this.subStages.values();
    }

    private synchronized void parentTasksAdded(List<TaskId> parentTasks, boolean noMoreParentNodes) {
        OutputBuffers newOutputBuffers;
        OutputBuffers startingOutputBuffers;
        Preconditions.checkNotNull(parentTasks, (Object)"parentTasks is null");
        OutputBuffers outputBuffers = startingOutputBuffers = this.nextOutputBuffers != null ? this.nextOutputBuffers : this.currentOutputBuffers;
        if (this.fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.NONE) {
            ImmutableMap.Builder newBuffers = ImmutableMap.builder();
            for (TaskId taskId : parentTasks) {
                newBuffers.put((Object)taskId, (Object)new UnpartitionedPagePartitionFunction());
            }
            newOutputBuffers = startingOutputBuffers.withBuffers((Map<TaskId, PagePartitionFunction>)newBuffers.build());
            if (noMoreParentNodes) {
                newOutputBuffers = newOutputBuffers.withNoMoreBufferIds();
            }
        } else if (this.fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.HASH) {
            Preconditions.checkArgument((boolean)noMoreParentNodes, (Object)"Hash partitioned output requires all parent nodes be added in a single call");
            PlanFragment.NullPartitioning nullPartitioning = this.fragment.getNullPartitionPolicy().get();
            ImmutableMap.Builder buffers = ImmutableMap.builder();
            for (int nodeIndex = 0; nodeIndex < parentTasks.size(); ++nodeIndex) {
                TaskId taskId = parentTasks.get(nodeIndex);
                buffers.put((Object)taskId, (Object)new HashPagePartitionFunction(nodeIndex, parentTasks.size(), SqlStageExecution.getPartitioningChannels(this.fragment).get(), SqlStageExecution.getHashChannel(this.fragment), this.fragment.getTypes(), nullPartitioning));
            }
            newOutputBuffers = startingOutputBuffers.withBuffers((Map<TaskId, PagePartitionFunction>)buffers.build()).withNoMoreBufferIds();
        } else if (this.fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.ROUND_ROBIN) {
            Preconditions.checkArgument((boolean)noMoreParentNodes, (Object)"Round-robin partitioned output requires all parent nodes be added in a single call");
            ImmutableMap.Builder buffers = ImmutableMap.builder();
            for (int nodeIndex = 0; nodeIndex < parentTasks.size(); ++nodeIndex) {
                TaskId taskId = parentTasks.get(nodeIndex);
                buffers.put((Object)taskId, (Object)new PartitionedPagePartitionFunction(nodeIndex, parentTasks.size()));
            }
            newOutputBuffers = startingOutputBuffers.withBuffers((Map<TaskId, PagePartitionFunction>)buffers.build()).withNoMoreBufferIds();
        } else {
            throw new UnsupportedOperationException("Unsupported output partitioning " + (Object)((Object)this.fragment.getOutputPartitioning()));
        }
        if (newOutputBuffers.getVersion() != startingOutputBuffers.getVersion()) {
            this.nextOutputBuffers = newOutputBuffers;
            this.notifyAll();
        }
    }

    private synchronized OutputBuffers getCurrentOutputBuffers() {
        return this.currentOutputBuffers;
    }

    private synchronized OutputBuffers updateToNextOutputBuffers() {
        if (this.nextOutputBuffers == null) {
            return this.currentOutputBuffers;
        }
        this.currentOutputBuffers = this.nextOutputBuffers;
        this.nextOutputBuffers = null;
        this.notifyAll();
        return this.currentOutputBuffers;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener::stateChanged);
    }

    private Multimap<PlanNodeId, URI> getNewExchangeLocations() {
        Multimap<PlanNodeId, URI> exchangeLocations = this.exchangeLocations.get();
        ImmutableMultimap.Builder newExchangeLocations = ImmutableMultimap.builder();
        for (RemoteSourceNode remoteSourceNode : this.fragment.getRemoteSourceNodes()) {
            for (PlanFragmentId planFragmentId : remoteSourceNode.getSourceFragmentIds()) {
                SqlStageExecution subStage = this.subStages.get(planFragmentId);
                Preconditions.checkState((subStage != null ? 1 : 0) != 0, (String)"Unknown sub stage %s, known stages %s", (Object[])new Object[]{planFragmentId, this.subStages.keySet()});
                for (URI taskLocation : subStage.getTaskLocations()) {
                    if (exchangeLocations.containsEntry((Object)remoteSourceNode.getId(), (Object)taskLocation)) continue;
                    newExchangeLocations.putAll((Object)remoteSourceNode.getId(), (Object[])new URI[]{taskLocation});
                }
            }
        }
        return newExchangeLocations.build();
    }

    private synchronized List<URI> getTaskLocations() {
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            ImmutableList.Builder locations = ImmutableList.builder();
            for (RemoteTask task : this.tasks.values()) {
                locations.add((Object)task.getTaskInfo().getSelf());
            }
            ImmutableList immutableList = locations.build();
            return immutableList;
        }
    }

    @VisibleForTesting
    public List<RemoteTask> getAllTasks() {
        return ImmutableList.copyOf(this.tasks.values());
    }

    @VisibleForTesting
    public List<RemoteTask> getTasks(Node node) {
        return FluentIterable.from((Iterable)this.localNodeTaskMap.get((Object)node)).transform(Functions.forMap(this.tasks)).toList();
    }

    public Future<?> start() {
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            Future<?> future = this.scheduleStartTasks();
            return future;
        }
    }

    private Future<?> scheduleStartTasks() {
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            this.subStages.values().forEach(SqlStageExecution::scheduleStartTasks);
            Future<?> future = this.executor.submit(this::startTasks);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTasks() {
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            block31: {
                Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not start while holding a lock on this");
                if (this.stateMachine.transitionToScheduling()) break block31;
                this.doUpdateState();
                return;
            }
            try {
                if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.SINGLE) {
                    this.scheduleFixedNodeCount(1);
                } else if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.FIXED) {
                    this.scheduleFixedNodeCount(this.initialHashPartitions);
                } else if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.SOURCE) {
                    this.scheduleSourcePartitionedNodes();
                } else if (this.fragment.getDistribution() == PlanFragment.PlanDistribution.COORDINATOR_ONLY) {
                    this.scheduleOnCurrentNode();
                } else {
                    throw new IllegalStateException("Unsupported partitioning: " + (Object)((Object)this.fragment.getDistribution()));
                }
                this.stateMachine.transitionToScheduled();
                this.updateNewExchangesAndBuffers(true);
                this.doUpdateState();
            }
            catch (Throwable e) {
                try {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.stateMachine.transitionToFailed(e)) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.doUpdateState();
                }
            }
        }
    }

    private void scheduleFixedNodeCount(int nodeCount) {
        List<Node> nodes = this.nodeSelector.selectRandomNodes(nodeCount);
        Failures.checkCondition(!nodes.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        ImmutableList.Builder tasks = ImmutableList.builder();
        for (int taskId = 0; taskId < nodes.size(); ++taskId) {
            Node node = nodes.get(taskId);
            RemoteTask task = this.scheduleTask(taskId, node);
            tasks.add((Object)task.getTaskInfo().getTaskId());
        }
        for (SqlStageExecution subStage : this.subStages.values()) {
            subStage.parentTasksAdded((List<TaskId>)tasks.build(), true);
        }
    }

    private void scheduleOnCurrentNode() {
        Node node = this.nodeSelector.selectCurrentNode();
        RemoteTask task = this.scheduleTask(0, node);
        for (SqlStageExecution subStage : this.subStages.values()) {
            subStage.parentTasksAdded((List<TaskId>)ImmutableList.of((Object)task.getTaskInfo().getTaskId()), true);
        }
    }

    private void scheduleSourcePartitionedNodes() throws InterruptedException {
        AtomicInteger nextTaskId = new AtomicInteger(0);
        try (SplitSource splitSource = this.dataSource.get();){
            while (!splitSource.isFinished()) {
                if (this.getState().isDone()) {
                    break;
                }
                long start = System.nanoTime();
                ImmutableSet pendingSplits = ImmutableSet.copyOf((Collection)((Collection)MoreFutures.getFutureValue(splitSource.getNextBatch(this.splitBatchSize))));
                this.stateMachine.recordGetSplitTime(start);
                while (!pendingSplits.isEmpty() && !this.getState().isDone()) {
                    Multimap<Node, Split> splitAssignment = this.nodeSelector.computeAssignments((Set<Split>)pendingSplits, this.tasks.values());
                    pendingSplits = ImmutableSet.copyOf((Collection)Sets.difference((Set)pendingSplits, (Set)ImmutableSet.copyOf((Collection)splitAssignment.values())));
                    this.assignSplits(nextTaskId, splitAssignment);
                    if (pendingSplits.isEmpty()) continue;
                    this.waitForFreeNode(nextTaskId);
                }
            }
        }
        for (RemoteTask task : this.tasks.values()) {
            task.noMoreSplits(this.fragment.getPartitionedSource());
        }
        this.completeSources.add(this.fragment.getPartitionedSource());
        this.setNoMoreStageNodes();
    }

    private void assignSplits(AtomicInteger nextTaskId, Multimap<Node, Split> splitAssignment) {
        for (Map.Entry taskSplits : splitAssignment.asMap().entrySet()) {
            RemoteTask task;
            long scheduleSplitStart = System.nanoTime();
            Node node = (Node)taskSplits.getKey();
            TaskId taskId = (TaskId)Iterables.getOnlyElement((Iterable)this.localNodeTaskMap.get((Object)node), null);
            RemoteTask remoteTask = task = taskId != null ? (RemoteTask)this.tasks.get(taskId) : null;
            if (task == null) {
                RemoteTask remoteTask2 = this.scheduleTask(nextTaskId.getAndIncrement(), node, this.fragment.getPartitionedSource(), (Iterable)taskSplits.getValue());
                this.addStageNode(remoteTask2.getTaskInfo().getTaskId());
                this.stateMachine.recordScheduleTaskTime(scheduleSplitStart);
                continue;
            }
            task.addSplits(this.fragment.getPartitionedSource(), (Iterable)taskSplits.getValue());
            this.stateMachine.recordAddSplit(scheduleSplitStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFreeNode(AtomicInteger nextTaskId) {
        if (!this.subStages.isEmpty()) {
            this.nodeSelector.lockDownNodes();
            for (Node node : Sets.difference(new HashSet<Node>(this.nodeSelector.allNodes()), (Set)this.localNodeTaskMap.keySet())) {
                RemoteTask remoteTask = this.scheduleTask(nextTaskId.getAndIncrement(), node);
                this.addStageNode(remoteTask.getTaskInfo().getTaskId());
            }
            this.setNoMoreStageNodes();
        }
        SqlStageExecution sqlStageExecution = this;
        synchronized (sqlStageExecution) {
            try {
                TimeUnit.MILLISECONDS.timedWait(this, 100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.updateNewExchangesAndBuffers(false);
    }

    private void addStageNode(TaskId task) {
        for (SqlStageExecution subStage : this.subStages.values()) {
            subStage.parentTasksAdded((List<TaskId>)ImmutableList.of((Object)task), false);
        }
    }

    private void setNoMoreStageNodes() {
        for (SqlStageExecution subStage : this.subStages.values()) {
            subStage.parentTasksAdded((List<TaskId>)ImmutableList.of(), true);
        }
    }

    private RemoteTask scheduleTask(int id, Node node) {
        return this.scheduleTask(id, node, null, (Iterable<Split>)ImmutableList.of());
    }

    private RemoteTask scheduleTask(int id, Node node, PlanNodeId sourceId, Iterable<Split> sourceSplits) {
        this.addNewExchangesAndBuffers();
        TaskId taskId = new TaskId(this.stateMachine.getStageId(), String.valueOf(id));
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : sourceSplits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        for (Map.Entry entry : this.exchangeLocations.get().entries()) {
            initialSplits.put(entry.getKey(), (Object)SqlStageExecution.createRemoteSplitFor(taskId, (URI)entry.getValue()));
        }
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(this.stateMachine.getSession(), taskId, node, this.fragment, (Multimap<PlanNodeId, Split>)initialSplits.build(), this.getCurrentOutputBuffers());
        task.addStateChangeListener((TaskInfo taskInfo) -> this.doUpdateState());
        task.start();
        this.tasks.put(task.getTaskInfo().getTaskId(), task);
        this.localNodeTaskMap.put((Object)node, (Object)task.getTaskInfo().getTaskId());
        this.nodeTaskMap.addTask(node, task);
        if (this.stateMachine.getState().isDone()) {
            task.cancel();
        }
        this.doUpdateState();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewExchangesAndBuffers(boolean waitUntilFinished) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not add exchanges or buffers to tasks while holding a lock on this");
        while (!this.getState().isDone()) {
            boolean finished = this.addNewExchangesAndBuffers();
            if (finished || !waitUntilFinished) {
                return;
            }
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                try {
                    TimeUnit.MILLISECONDS.timedWait(this, 100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
    }

    private boolean addNewExchangesAndBuffers() {
        Set<PlanNodeId> completeSources = this.updateCompleteSources();
        boolean allSourceComplete = completeSources.containsAll(this.allSources);
        Multimap<PlanNodeId, URI> newExchangeLocations = this.getNewExchangeLocations();
        this.exchangeLocations.set((Multimap<PlanNodeId, URI>)ImmutableMultimap.builder().putAll(this.exchangeLocations.get()).putAll(newExchangeLocations).build());
        OutputBuffers outputBuffers = this.updateToNextOutputBuffers();
        boolean finished = allSourceComplete && outputBuffers.isNoMoreBufferIds();
        try (SetThreadName ignored = new SetThreadName("SqlStageExecution-%s", new Object[]{this.stateMachine.getStageId()});){
            for (RemoteTask task : this.tasks.values()) {
                for (Map.Entry entry : newExchangeLocations.entries()) {
                    Split remoteSplit = SqlStageExecution.createRemoteSplitFor(task.getTaskInfo().getTaskId(), (URI)entry.getValue());
                    task.addSplits((PlanNodeId)entry.getKey(), (Iterable<Split>)ImmutableList.of((Object)remoteSplit));
                }
                task.setOutputBuffers(outputBuffers);
                completeSources.forEach(task::noMoreSplits);
            }
        }
        return finished;
    }

    private Set<PlanNodeId> updateCompleteSources() {
        for (RemoteSourceNode remoteSourceNode : this.fragment.getRemoteSourceNodes()) {
            boolean exchangeFinished;
            if (this.completeSources.contains(remoteSourceNode.getId()) || !(exchangeFinished = remoteSourceNode.getSourceFragmentIds().stream().allMatch(this::isExchangeFinished))) continue;
            this.completeSources.add(remoteSourceNode.getId());
        }
        return this.completeSources;
    }

    private boolean isExchangeFinished(PlanFragmentId planFragmentId) {
        SqlStageExecution subStage = this.subStages.get(planFragmentId);
        switch (subStage.getState()) {
            case SCHEDULED: 
            case RUNNING: 
            case FINISHED: 
            case CANCELED: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateState() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not doUpdateState while holding a lock on this");
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            SqlStageExecution sqlStageExecution = this;
            synchronized (sqlStageExecution) {
                StageState initialState;
                block28: {
                    this.notifyAll();
                    initialState = this.getState();
                    if (!initialState.isDone()) break block28;
                    return;
                }
                List taskInfos = (List)this.tasks.values().stream().map(RemoteTask::getTaskInfo).collect(ImmutableCollectors.toImmutableList());
                List taskStates = (List)taskInfos.stream().map(TaskInfo::getState).collect(ImmutableCollectors.toImmutableList());
                if (Iterables.any((Iterable)taskStates, (Predicate)Predicates.equalTo((Object)((Object)TaskState.FAILED)))) {
                    RuntimeException failure = taskInfos.stream().map(taskInfo -> (ExecutionFailureInfo)Iterables.getFirst(taskInfo.getFailures(), null)).filter(Objects::nonNull).findFirst().map(ExecutionFailureInfo::toException).orElse((RuntimeException)((Object)new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "A task failed for an unknown reason")));
                    this.stateMachine.transitionToFailed(failure);
                } else if (taskStates.stream().anyMatch(TaskState.ABORTED::equals)) {
                    this.stateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "A task is in the ABORTED state but stage is " + (Object)((Object)initialState)));
                } else if (initialState != StageState.PLANNED && initialState != StageState.SCHEDULING) {
                    if (taskStates.stream().allMatch(TaskState::isDone)) {
                        this.stateMachine.transitionToFinished();
                    } else if (taskStates.stream().anyMatch(TaskState.RUNNING::equals)) {
                        this.stateMachine.transitionToRunning();
                    }
                }
            }
            if (this.getState().isDone()) {
                this.cancel();
            }
        }
    }

    public void cancel() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not cancel while holding a lock on this");
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            this.doUpdateState();
            this.stateMachine.transitionToCanceled();
            this.tasks.values().forEach(RemoteTask::cancel);
            this.subStages.values().forEach(SqlStageExecution::cancel);
        }
    }

    public void abort() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not abort while holding a lock on this");
        try (SetThreadName ignored = new SetThreadName("Stage-%s", new Object[]{this.stateMachine.getStageId()});){
            this.doUpdateState();
            this.stateMachine.transitionToAborted();
            this.tasks.values().forEach(RemoteTask::abort);
            this.subStages.values().forEach(SqlStageExecution::abort);
        }
    }

    private static Split createRemoteSplitFor(TaskId taskId, URI taskLocation) {
        URI splitLocation = HttpUriBuilder.uriBuilderFrom((URI)taskLocation).appendPath("results").appendPath(taskId.toString()).build();
        return new Split("remote", new RemoteSplit(splitLocation));
    }

    public String toString() {
        return this.stateMachine.toString();
    }

    private static Optional<Integer> getHashChannel(PlanFragment fragment) {
        return fragment.getHash().map(symbol -> fragment.getOutputLayout().indexOf(symbol));
    }

    private static Optional<List<Integer>> getPartitioningChannels(PlanFragment fragment) {
        Preconditions.checkState((fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.HASH ? 1 : 0) != 0, (Object)"fragment is not hash partitioned");
        return fragment.getPartitionBy().map(t -> t.stream().map(symbol -> fragment.getOutputLayout().indexOf(symbol)).collect(ImmutableCollectors.toImmutableList()));
    }
}

