/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.MemoryTrackingRemoteTaskFactory;
import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DistributedExecutionPlanner;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class SqlQueryExecution
implements QueryExecution {
    private static final OutputBuffers ROOT_OUTPUT_BUFFERS = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(new TaskId("output", "buffer", "id"), new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds();
    private final QueryStateMachine stateMachine;
    private final Statement statement;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final RemoteTaskFactory remoteTaskFactory;
    private final LocationFactory locationFactory;
    private final int scheduleSplitBatchSize;
    private final int initialHashPartitions;
    private final boolean experimentalSyntaxEnabled;
    private final ExecutorService queryExecutor;
    private final QueryExplainer queryExplainer;
    private final AtomicReference<SqlStageExecution> outputStage = new AtomicReference();
    private final AtomicReference<QueryInfo> finalQueryInfo = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final Session session;

    public SqlQueryExecution(QueryId queryId, String query, Session session, URI self, Statement statement, Metadata metadata, SqlParser sqlParser, SplitManager splitManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, RemoteTaskFactory remoteTaskFactory, LocationFactory locationFactory, int scheduleSplitBatchSize, int initialHashPartitions, boolean experimentalSyntaxEnabled, ExecutorService queryExecutor, NodeTaskMap nodeTaskMap) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{queryId});){
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement, (Object)"statement is null");
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
            this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
            this.nodeScheduler = (NodeScheduler)Preconditions.checkNotNull((Object)nodeScheduler, (Object)"nodeScheduler is null");
            this.planOptimizers = (List)Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
            this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
            this.queryExecutor = (ExecutorService)Preconditions.checkNotNull((Object)queryExecutor, (Object)"queryExecutor is null");
            this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
            this.nodeTaskMap = (NodeTaskMap)Preconditions.checkNotNull((Object)nodeTaskMap, (Object)"nodeTaskMap is null");
            this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            Preconditions.checkArgument((initialHashPartitions > 0 ? 1 : 0) != 0, (Object)"initialHashPartitions must be greater than 0");
            this.initialHashPartitions = initialHashPartitions;
            Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
            Preconditions.checkNotNull((Object)query, (Object)"query is null");
            Preconditions.checkNotNull((Object)session, (Object)"session is null");
            Preconditions.checkNotNull((Object)self, (Object)"self is null");
            this.stateMachine = new QueryStateMachine(queryId, query, session, self, queryExecutor);
            this.stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlStageExecution stage = this.outputStage.get();
                if (stage != null) {
                    stage.abort();
                }
                this.finalQueryInfo.compareAndSet(null, this.getQueryInfo(stage));
                this.outputStage.set(null);
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory((RemoteTaskFactory)Preconditions.checkNotNull((Object)remoteTaskFactory, (Object)"remoteTaskFactory is null"), this.stateMachine);
            this.queryExplainer = new QueryExplainer(session, planOptimizers, metadata, sqlParser, experimentalSyntaxEnabled);
        }
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public long getTotalMemoryReservation() {
        SqlStageExecution stage = this.outputStage.get();
        QueryInfo queryInfo = this.finalQueryInfo.get();
        if (queryInfo != null) {
            return queryInfo.getQueryStats().getTotalMemoryReservation().toBytes();
        }
        return stage.getTotalMemoryReservation();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void start() {
        Throwable throwable;
        SetThreadName ignored;
        block24: {
            block25: {
                block26: {
                    block21: {
                        block22: {
                            block23: {
                                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                                throwable = null;
                                if (this.stateMachine.transitionToPlanning()) break block21;
                                if (ignored == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ignored.close();
                        }
                        return;
                    }
                    SubPlan subplan = this.analyzeQuery();
                    this.planDistribution(subplan);
                    if (this.stateMachine.transitionToStarting()) break block24;
                    if (ignored == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                SqlStageExecution stage = this.outputStage.get();
                if (!this.stateMachine.isDone()) {
                    stage.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    private SubPlan analyzeQuery() {
        try {
            return this.doAnalyzeQuery();
        }
        catch (StackOverflowError e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private SubPlan doAnalyzeQuery() {
        long analysisStart = System.nanoTime();
        Analyzer analyzer = new Analyzer(this.stateMachine.getSession(), this.metadata, this.sqlParser, Optional.of(this.queryExplainer), this.experimentalSyntaxEnabled);
        Analysis analysis = analyzer.analyze(this.statement);
        this.stateMachine.setUpdateType(analysis.getUpdateType());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.metadata);
        Plan plan = logicalPlanner.plan(analysis);
        List<Input> inputs = new InputExtractor(this.metadata, this.session).extract(plan.getRoot());
        this.stateMachine.setInputs(inputs);
        SubPlan subplan = new PlanFragmenter().createSubPlans(plan);
        this.stateMachine.recordAnalysisTime(analysisStart);
        return subplan;
    }

    private void planDistribution(SubPlan subplan) {
        long distributedPlanningStart = System.nanoTime();
        DistributedExecutionPlanner distributedPlanner = new DistributedExecutionPlanner(this.splitManager);
        StageExecutionPlan outputStageExecutionPlan = distributedPlanner.plan(subplan, this.session);
        if (this.stateMachine.isDone()) {
            return;
        }
        this.stateMachine.setOutputFieldNames(outputStageExecutionPlan.getFieldNames());
        SqlStageExecution outputStage = new SqlStageExecution(this.stateMachine.getQueryId(), this.locationFactory, outputStageExecutionPlan, this.nodeScheduler, this.remoteTaskFactory, this.stateMachine.getSession(), this.scheduleSplitBatchSize, this.initialHashPartitions, this.queryExecutor, this.nodeTaskMap, ROOT_OUTPUT_BUFFERS);
        outputStage.addStateChangeListener((StageState state) -> {
            if (state == StageState.FINISHED) {
                this.stateMachine.transitionToFinished();
            } else if (state == StageState.CANCELED) {
                this.stateMachine.transitionToFailed((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled"));
            }
        });
        for (SqlStageExecution stage : SqlQueryExecution.getAllStages(outputStage)) {
            stage.addStateChangeListener((StageState state) -> {
                if (this.stateMachine.isDone()) {
                    return;
                }
                if (state == StageState.FAILED) {
                    this.stateMachine.transitionToFailed(stage.getStageInfo().getFailureCause().toException());
                } else if (state == StageState.ABORTED) {
                    this.stateMachine.transitionToFailed((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Query stage was aborted"));
                } else if (this.stateMachine.getQueryState() == QueryState.STARTING && !stage.getStageInfo().getTasks().isEmpty()) {
                    this.stateMachine.transitionToRunning();
                }
            });
        }
        this.outputStage.set(outputStage);
        if (this.stateMachine.isDone()) {
            outputStage.abort();
        }
        this.stateMachine.recordDistributedPlanningTime(distributedPlanningStart);
    }

    @Override
    public void cancelStage(StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlStageExecution stageExecution = this.outputStage.get();
            if (stageExecution != null) {
                stageExecution.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.transitionToFailed(cause);
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            Duration duration = this.stateMachine.waitForStateChange(currentState, maxWait);
            return duration;
        }
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        QueryInfo queryInfo = this.finalQueryInfo.get();
        if (queryInfo == null || queryInfo.getOutputStage() == null) {
            return;
        }
        StageInfo prunedOutputStage = new StageInfo(queryInfo.getOutputStage().getStageId(), queryInfo.getOutputStage().getState(), queryInfo.getOutputStage().getSelf(), null, queryInfo.getOutputStage().getTypes(), queryInfo.getOutputStage().getStageStats(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), queryInfo.getOutputStage().getFailureCause());
        QueryInfo prunedQueryInfo = new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), this.getMemoryPool().getId(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryInfo.getQueryStats(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getUpdateType(), prunedOutputStage, queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getInputs());
        this.finalQueryInfo.compareAndSet(queryInfo, prunedQueryInfo);
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlStageExecution outputStage = this.outputStage.get();
            QueryInfo finalQueryInfo = this.finalQueryInfo.get();
            if (finalQueryInfo != null) {
                QueryInfo queryInfo = finalQueryInfo;
                return queryInfo;
            }
            QueryInfo queryInfo = this.getQueryInfo(outputStage);
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    private QueryInfo getQueryInfo(SqlStageExecution outputStage) {
        StageInfo stageInfo = null;
        if (outputStage != null) {
            stageInfo = outputStage.getStageInfo();
        }
        return this.stateMachine.getQueryInfo(stageInfo);
    }

    private static List<SqlStageExecution> getAllStages(SqlStageExecution stage) {
        ImmutableList.Builder collector = ImmutableList.builder();
        if (stage != null) {
            SqlQueryExecution.addAllStages(stage, (ImmutableList.Builder<SqlStageExecution>)collector);
        }
        return collector.build();
    }

    private static void addAllStages(SqlStageExecution stage, ImmutableList.Builder<SqlStageExecution> collector) {
        collector.add((Object)stage);
        for (SqlStageExecution subStage : stage.getSubStages()) {
            SqlQueryExecution.addAllStages(subStage, collector);
        }
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<SqlQueryExecution> {
        private final int scheduleSplitBatchSize;
        private final boolean experimentalSyntaxEnabled;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final RemoteTaskFactory remoteTaskFactory;
        private final LocationFactory locationFactory;
        private final ExecutorService executor;
        private final NodeTaskMap nodeTaskMap;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, FeaturesConfig featuresConfig, Metadata metadata, SqlParser sqlParser, LocationFactory locationFactory, SplitManager splitManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, RemoteTaskFactory remoteTaskFactory, @ForQueryExecution ExecutorService executor, NodeTaskMap nodeTaskMap) {
            Preconditions.checkNotNull((Object)config, (Object)"config is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
            this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
            this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
            this.nodeScheduler = (NodeScheduler)Preconditions.checkNotNull((Object)nodeScheduler, (Object)"nodeScheduler is null");
            this.planOptimizers = (List)Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
            this.remoteTaskFactory = (RemoteTaskFactory)Preconditions.checkNotNull((Object)remoteTaskFactory, (Object)"remoteTaskFactory is null");
            Preconditions.checkNotNull((Object)featuresConfig, (Object)"featuresConfig is null");
            this.experimentalSyntaxEnabled = featuresConfig.isExperimentalSyntaxEnabled();
            this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
            this.nodeTaskMap = (NodeTaskMap)Preconditions.checkNotNull((Object)nodeTaskMap, (Object)"nodeTaskMap is null");
        }

        @Override
        public SqlQueryExecution createQueryExecution(QueryId queryId, String query, Session session, Statement statement) {
            return new SqlQueryExecution(queryId, query, session, this.locationFactory.createQueryLocation(queryId), statement, this.metadata, this.sqlParser, this.splitManager, this.nodeScheduler, this.planOptimizers, this.remoteTaskFactory, this.locationFactory, this.scheduleSplitBatchSize, SystemSessionProperties.getHashPartitionCount(session), this.experimentalSyntaxEnabled, this.executor, this.nodeTaskMap);
        }
    }
}

