/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.Marker;
import com.facebook.presto.spi.SerializableNativeValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleMarker {
    private final boolean inclusive;
    private final Comparable<?> value;
    private final Class<?> type;

    private SimpleMarker(boolean inclusive, Comparable<?> value, Class<?> type) {
        Preconditions.checkNotNull(value, (Object)"value is null");
        Preconditions.checkNotNull(type, (Object)"type is null");
        Preconditions.checkArgument((boolean)type.isInstance(value), (Object)String.format("value (%s) must be of specified type (%s)", value, type));
        this.inclusive = inclusive;
        this.value = value;
        this.type = type;
    }

    @JsonCreator
    public SimpleMarker(@JsonProperty(value="inclusive") boolean inclusive, @JsonProperty(value="value") SerializableNativeValue value) {
        this(inclusive, value.getValue(), value.getType());
    }

    @JsonProperty
    public boolean isInclusive() {
        return this.inclusive;
    }

    @JsonIgnore
    public Comparable<?> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public SerializableNativeValue getSerializableNativeValue() {
        return new SerializableNativeValue(this.type, this.value);
    }

    public static SimpleMarker fromMarker(Marker marker) {
        if (marker == null || marker.isUpperUnbounded() || marker.isLowerUnbounded()) {
            return null;
        }
        return new SimpleMarker(marker.getBound() == Marker.Bound.EXACTLY, marker.getValue(), marker.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMarker that = (SimpleMarker)o;
        return Objects.equals(this.inclusive, that.inclusive) && Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.inclusive, this.value, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.inclusive).addValue(this.value).addValue(this.type).toString();
    }
}

