/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameTable;
import java.util.Optional;

public class RenameTableTask
implements DataDefinitionTask<RenameTable> {
    @Override
    public String getName() {
        return "RENAME TABLE";
    }

    @Override
    public void execute(RenameTable statement, Session session, Metadata metadata, QueryStateMachine stateMachine) {
        QualifiedTableName tableName = MetadataUtil.createQualifiedTableName(session, statement.getSource());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        QualifiedTableName target = MetadataUtil.createQualifiedTableName(session, statement.getTarget());
        if (!metadata.getCatalogNames().containsKey(target.getCatalogName())) {
            throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (metadata.getTableHandle(session, target).isPresent()) {
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target table '%s' already exists", target);
        }
        metadata.renameTable(session, tableHandle.get(), target);
    }
}

