/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameColumn;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public void execute(RenameColumn statement, Session session, Metadata metadata, QueryStateMachine stateMachine) {
        QualifiedTableName tableName = MetadataUtil.createQualifiedTableName(session, statement.getTable());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        String source = statement.getSource().toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().toLowerCase(Locale.ENGLISH);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
        if (!columnHandles.containsKey(source)) {
            throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", source);
        }
        if (columnHandles.containsKey(target)) {
            throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
        }
        metadata.renameColumn(session, tableHandle.get(), columnHandles.get(source), target);
    }
}

