/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryQueue;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.SetThreadName;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

public class QueuedExecution {
    private final QueryExecution queryExecution;
    private final List<QueryQueue> nextQueues;
    private final ListenableFuture<?> listenableFuture;
    private final Executor executor;
    private final SqlQueryManagerStats stats;

    public static QueuedExecution createQueuedExecution(QueryExecution queryExecution, List<QueryQueue> nextQueues, Executor executor, SqlQueryManagerStats stats) {
        SettableFuture settableFuture = SettableFuture.create();
        SqlQueryManager.addCompletionCallback(queryExecution, () -> settableFuture.set(null));
        return new QueuedExecution(queryExecution, nextQueues, executor, stats, (ListenableFuture<?>)settableFuture);
    }

    private QueuedExecution(QueryExecution queryExecution, List<QueryQueue> nextQueues, Executor executor, SqlQueryManagerStats stats, ListenableFuture<?> listenableFuture) {
        this.queryExecution = (QueryExecution)Preconditions.checkNotNull((Object)queryExecution, (Object)"queryExecution is null");
        this.nextQueues = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(nextQueues, (Object)"nextQueues is null")));
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.stats = (SqlQueryManagerStats)Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
        this.listenableFuture = (ListenableFuture)Preconditions.checkNotNull(listenableFuture, (Object)"listenableFuture is null");
    }

    public ListenableFuture<?> getCompletionFuture() {
        return this.listenableFuture;
    }

    public void start() {
        if (this.listenableFuture.isDone()) {
            return;
        }
        if (this.nextQueues.isEmpty()) {
            this.executor.execute(() -> {
                try (SetThreadName setThreadName = new SetThreadName("Query-%s", new Object[]{this.queryExecution.getQueryInfo().getQueryId()});){
                    this.stats.queryStarted();
                    this.listenableFuture.addListener(this.stats::queryStopped, MoreExecutors.directExecutor());
                    this.queryExecution.start();
                }
            });
        } else if (!this.nextQueues.get(0).enqueue(new QueuedExecution(this.queryExecution, this.nextQueues.subList(1, this.nextQueues.size()), this.executor, this.stats, this.listenableFuture))) {
            this.queryExecution.fail(new IllegalStateException("Entering secondary queue failed"));
        }
    }
}

