/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueuedExecution;
import com.facebook.presto.execution.SqlQueryManager;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.AsyncSemaphore;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.weakref.jmx.Managed;

public class QueryQueue {
    private final int maxQueuedQueries;
    private final AtomicInteger queryQueueSize = new AtomicInteger();
    private final AtomicInteger queuePermits;
    private final AsyncSemaphore<QueueEntry> asyncSemaphore;

    QueryQueue(Executor queryExecutor, int maxQueuedQueries, int maxConcurrentQueries) {
        Preconditions.checkNotNull((Object)queryExecutor, (Object)"queryExecutor is null");
        Preconditions.checkArgument((maxQueuedQueries > 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries must be greater than zero");
        Preconditions.checkArgument((maxConcurrentQueries > 0 ? 1 : 0) != 0, (Object)"maxConcurrentQueries must be greater than zero");
        this.maxQueuedQueries = maxQueuedQueries;
        this.queuePermits = new AtomicInteger(maxQueuedQueries + maxConcurrentQueries);
        this.asyncSemaphore = new AsyncSemaphore(maxConcurrentQueries, queryExecutor, queueEntry -> {
            QueuedExecution queuedExecution = queueEntry.dequeue();
            if (queuedExecution != null) {
                queuedExecution.start();
                return queuedExecution.getCompletionFuture();
            }
            return Futures.immediateFuture(null);
        });
    }

    @Managed
    public int getQueueSize() {
        return this.queryQueueSize.get();
    }

    public boolean reserve(QueryExecution queryExecution) {
        if (this.queuePermits.decrementAndGet() < 0) {
            this.queuePermits.incrementAndGet();
            return false;
        }
        SqlQueryManager.addCompletionCallback(queryExecution, this.queuePermits::incrementAndGet);
        return true;
    }

    public boolean enqueue(QueuedExecution queuedExecution) {
        if (this.queryQueueSize.incrementAndGet() > this.maxQueuedQueries) {
            this.queryQueueSize.decrementAndGet();
            return false;
        }
        QueueEntry entry = new QueueEntry(queuedExecution, this.queryQueueSize::decrementAndGet);
        queuedExecution.getCompletionFuture().addListener(entry::dequeue, MoreExecutors.directExecutor());
        this.asyncSemaphore.submit((Object)entry);
        return true;
    }

    private static class QueueEntry {
        private final AtomicReference<QueuedExecution> queryExecution;
        private final Runnable onDequeue;

        private QueueEntry(QueuedExecution queuedExecution, Runnable onDequeue) {
            Preconditions.checkNotNull((Object)queuedExecution, (Object)"queueableExecution is null");
            this.queryExecution = new AtomicReference<QueuedExecution>(queuedExecution);
            this.onDequeue = (Runnable)Preconditions.checkNotNull((Object)onDequeue, (Object)"onDequeue is null");
        }

        public QueuedExecution dequeue() {
            QueuedExecution value = this.queryExecution.getAndSet(null);
            if (value != null) {
                this.onDequeue.run();
            }
            return value;
        }
    }
}

