/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.memory.MemoryPoolId;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final MemoryPoolId memoryPool;
    private final boolean scheduled;
    private final URI self;
    private final List<String> fieldNames;
    private final String query;
    private final QueryStats queryStats;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final String updateType;
    private final StageInfo outputStage;
    private final FailureInfo failureInfo;
    private final StandardErrorCode.ErrorType errorType;
    private final ErrorCode errorCode;
    private final Set<Input> inputs;

    @JsonCreator
    public QueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="memoryPool") MemoryPoolId memoryPool, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="query") String query, @JsonProperty(value="queryStats") QueryStats queryStats, @JsonProperty(value="setSessionProperties") Map<String, String> setSessionProperties, @JsonProperty(value="resetSessionProperties") Set<String> resetSessionProperties, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="outputStage") StageInfo outputStage, @JsonProperty(value="failureInfo") FailureInfo failureInfo, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="inputs") Set<Input> inputs) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)((Object)state), (Object)"state is null");
        Preconditions.checkNotNull((Object)self, (Object)"self is null");
        Preconditions.checkNotNull(fieldNames, (Object)"fieldNames is null");
        Preconditions.checkNotNull((Object)queryStats, (Object)"queryStats is null");
        Preconditions.checkNotNull(setSessionProperties, (Object)"setSessionProperties is null");
        Preconditions.checkNotNull(resetSessionProperties, (Object)"resetSessionProperties is null");
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        Preconditions.checkNotNull(inputs, (Object)"inputs is null");
        this.queryId = queryId;
        this.session = session;
        this.state = state;
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.scheduled = scheduled;
        this.self = self;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.query = query;
        this.queryStats = queryStats;
        this.setSessionProperties = ImmutableMap.copyOf(setSessionProperties);
        this.resetSessionProperties = ImmutableSet.copyOf(resetSessionProperties);
        this.updateType = updateType;
        this.outputStage = outputStage;
        this.failureInfo = failureInfo;
        this.errorType = errorCode == null ? null : StandardErrorCode.toErrorType((int)errorCode.getCode());
        this.errorCode = errorCode;
        this.inputs = ImmutableSet.copyOf(inputs);
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public MemoryPoolId getMemoryPool() {
        return this.memoryPool;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    @JsonProperty
    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    @JsonProperty
    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public StageInfo getOutputStage() {
        return this.outputStage;
    }

    @Nullable
    @JsonProperty
    public FailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Nullable
    @JsonProperty
    public StandardErrorCode.ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public Set<Input> getInputs() {
        return this.inputs;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).add("fieldNames", this.fieldNames).toString();
    }
}

