/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.spi.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NodeTaskMap {
    private final ConcurrentHashMap<Node, NodeTasks> nodeTasksMap = new ConcurrentHashMap();

    public void addTask(Node node, RemoteTask task) {
        NodeTasks nodeTasks = this.nodeTasksMap.get(node);
        if (nodeTasks == null) {
            nodeTasks = this.addNodeTask(node);
        }
        nodeTasks.addTask(task);
    }

    private NodeTasks addNodeTask(Node node) {
        NodeTasks newNodeTasks = new NodeTasks();
        NodeTasks nodeTasks = this.nodeTasksMap.putIfAbsent(node, newNodeTasks);
        if (nodeTasks == null) {
            return newNodeTasks;
        }
        return nodeTasks;
    }

    public int getPartitionedSplitsOnNode(Node node) {
        NodeTasks nodeTasks = this.nodeTasksMap.get(node);
        if (nodeTasks == null) {
            nodeTasks = this.addNodeTask(node);
        }
        return nodeTasks.getPartitionedSplitCount();
    }

    private static class NodeTasks {
        @GuardedBy(value="this")
        private final List<RemoteTask> remoteTasks = new ArrayList<RemoteTask>();

        private NodeTasks() {
        }

        private synchronized int getPartitionedSplitCount() {
            int partitionedSplitCount = 0;
            for (RemoteTask task : this.remoteTasks) {
                partitionedSplitCount += task.getPartitionedSplitCount();
            }
            return partitionedSplitCount;
        }

        private synchronized void addTask(RemoteTask task) {
            this.remoteTasks.add(task);
            task.addStateChangeListener(taskInfo -> {
                if (taskInfo.getState().isDone()) {
                    NodeTasks nodeTasks = this;
                    synchronized (nodeTasks) {
                        this.remoteTasks.remove(task);
                    }
                }
            });
            if (task.getTaskInfo().getState().isDone()) {
                this.remoteTasks.remove(task);
            }
        }
    }
}

