/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.collect.Multimap;
import java.util.Objects;

public class MemoryTrackingRemoteTaskFactory
implements RemoteTaskFactory {
    private final RemoteTaskFactory remoteTaskFactory;
    private final QueryStateMachine stateMachine;

    public MemoryTrackingRemoteTaskFactory(RemoteTaskFactory remoteTaskFactory, QueryStateMachine stateMachine) {
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, Node node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers) {
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(session, taskId, node, fragment, initialSplits, outputBuffers);
        task.addStateChangeListener(new UpdatePeakMemory(this.stateMachine));
        return task;
    }

    private static final class UpdatePeakMemory
    implements StateMachine.StateChangeListener<TaskInfo> {
        private final QueryStateMachine stateMachine;
        private long previousMemory;

        public UpdatePeakMemory(QueryStateMachine stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public synchronized void stateChanged(TaskInfo newState) {
            long currentMemory = newState.getStats().getMemoryReservation().toBytes();
            long deltaMemoryInBytes = currentMemory - this.previousMemory;
            this.previousMemory = currentMemory;
            this.stateMachine.updateMemoryUsage(deltaMemoryInBytes);
        }
    }
}

