/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;

public class FailedQueryExecution
implements QueryExecution {
    private final QueryInfo queryInfo;
    private final Session session;

    public FailedQueryExecution(QueryId queryId, String query, Session session, URI self, Executor executor, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.session = Objects.requireNonNull(session, "session is null");
        QueryStateMachine queryStateMachine = new QueryStateMachine(queryId, query, session, self, executor);
        queryStateMachine.transitionToFailed(cause);
        this.queryInfo = queryStateMachine.getQueryInfo(null);
    }

    @Override
    public QueryId getQueryId() {
        return this.queryInfo.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public QueryState getState() {
        return this.queryInfo.getState();
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L);
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
    }

    @Override
    public long getTotalMemoryReservation() {
        return 0L;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void start() {
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return maxWait;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        stateChangeListener.stateChanged(QueryState.FAILED);
    }

    @Override
    public void fail(Throwable cause) {
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public void pruneInfo() {
    }
}

