/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SimpleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class Column {
    private final String name;
    private final String type;
    private final Optional<SimpleDomain> domain;

    @JsonCreator
    public Column(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="domain") Optional<SimpleDomain> domain) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.domain = (Optional)Preconditions.checkNotNull(domain, (Object)"domain is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<SimpleDomain> getDomain() {
        return this.domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.domain, that.domain);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.domain);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).addValue((Object)this.type).addValue(this.domain).toString();
    }
}

