/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BufferResult {
    private final long token;
    private final long nextToken;
    private final boolean bufferClosed;
    private final List<Page> pages;

    public static BufferResult emptyResults(long token, boolean bufferClosed) {
        return new BufferResult(token, token, bufferClosed, (List<Page>)ImmutableList.of());
    }

    public BufferResult(long token, long nextToken, boolean bufferClosed, List<Page> pages) {
        this.token = token;
        this.nextToken = nextToken;
        this.bufferClosed = bufferClosed;
        this.pages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(pages, (Object)"pages is null")));
    }

    public long getToken() {
        return this.token;
    }

    public long getNextToken() {
        return this.nextToken;
    }

    public boolean isBufferClosed() {
        return this.bufferClosed;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public int size() {
        return this.pages.size();
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferResult that = (BufferResult)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.nextToken, that.nextToken) && Objects.equals(this.bufferClosed, that.bufferClosed) && Objects.equals(this.pages, that.pages);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.nextToken, this.bufferClosed, this.pages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("bufferClosed", this.bufferClosed).add("pages", this.pages).toString();
    }
}

