/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.spi.ErrorCode;
import com.google.common.collect.ImmutableList;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@EventType(value="QueryCompletion")
@Immutable
public class QueryCompletionEvent {
    private final QueryId queryId;
    private final String user;
    private final String source;
    private final String serverVersion;
    private final String environment;
    private final String catalog;
    private final String schema;
    private final String remoteClientAddress;
    private final String userAgent;
    private final QueryState queryState;
    private final URI uri;
    private final List<String> fieldNames;
    private final String query;
    private final Long peakMemoryBytes;
    private final DateTime createTime;
    private final DateTime executionStartTime;
    private final DateTime endTime;
    private final Long queuedTimeMs;
    private final Long analysisTimeMs;
    private final Long distributedPlanningTimeMs;
    private final Long totalSplitWallTimeMs;
    private final Long totalSplitCpuTimeMs;
    private final Long totalBytes;
    private final Long totalRows;
    private final Integer splits;
    private final ErrorCode errorCode;
    private final String failureType;
    private final String failureMessage;
    private final String failureTask;
    private final String failureHost;
    private final String outputStageJson;
    private final String failuresJson;
    private final String inputsJson;
    private final String sessionPropertiesJson;

    public QueryCompletionEvent(QueryId queryId, String user, String source, String serverVersion, String environment, String catalog, String schema, String remoteClientAddress, String userAgent, QueryState queryState, URI uri, List<String> fieldNames, String query, Long peakMemoryBytes, DateTime createTime, DateTime executionStartTime, DateTime endTime, Duration queuedTime, Duration analysisTime, Duration distributedPlanningTime, Duration totalSplitWallTime, Duration totalSplitCpuTime, DataSize totalDataSize, Long totalRows, Integer splits, ErrorCode errorCode, String failureType, String failureMessage, String failureTask, String failureHost, String outputStageJson, String failuresJson, String inputsJson, String sessionPropertiesJson) {
        this.queryId = queryId;
        this.user = user;
        this.source = source;
        this.serverVersion = serverVersion;
        this.environment = environment;
        this.catalog = catalog;
        this.schema = schema;
        this.remoteClientAddress = remoteClientAddress;
        this.userAgent = userAgent;
        this.queryState = queryState;
        this.uri = uri;
        this.errorCode = errorCode;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.peakMemoryBytes = peakMemoryBytes;
        this.query = query;
        this.createTime = createTime;
        this.executionStartTime = executionStartTime;
        this.endTime = endTime;
        this.queuedTimeMs = QueryCompletionEvent.durationToMillis(queuedTime);
        this.analysisTimeMs = QueryCompletionEvent.durationToMillis(analysisTime);
        this.distributedPlanningTimeMs = QueryCompletionEvent.durationToMillis(distributedPlanningTime);
        this.totalSplitWallTimeMs = QueryCompletionEvent.durationToMillis(totalSplitWallTime);
        this.totalSplitCpuTimeMs = QueryCompletionEvent.durationToMillis(totalSplitCpuTime);
        this.totalBytes = QueryCompletionEvent.sizeToBytes(totalDataSize);
        this.totalRows = totalRows;
        this.splits = splits;
        this.failureType = failureType;
        this.failureMessage = failureMessage;
        this.failureTask = failureTask;
        this.failureHost = failureHost;
        this.outputStageJson = outputStageJson;
        this.failuresJson = failuresJson;
        this.inputsJson = inputsJson;
        this.sessionPropertiesJson = sessionPropertiesJson;
    }

    @Nullable
    private static Long durationToMillis(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    @Nullable
    private static Long sizeToBytes(@Nullable DataSize dataSize) {
        if (dataSize == null) {
            return null;
        }
        return dataSize.toBytes();
    }

    @EventField
    public String getQueryId() {
        return this.queryId.toString();
    }

    @EventField
    public String getUser() {
        return this.user;
    }

    @EventField
    public String getSource() {
        return this.source;
    }

    @EventField
    public String getServerVersion() {
        return this.serverVersion;
    }

    @EventField
    public String getEnvironment() {
        return this.environment;
    }

    @EventField
    public String getCatalog() {
        return this.catalog;
    }

    @EventField
    public String getSchema() {
        return this.schema;
    }

    @EventField
    public String getRemoteClientAddress() {
        return this.remoteClientAddress;
    }

    @EventField
    public String getUserAgent() {
        return this.userAgent;
    }

    @EventField
    public String getQueryState() {
        return this.queryState.name();
    }

    @EventField
    public String getUri() {
        return this.uri.toString();
    }

    @EventField
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @EventField
    public String getQuery() {
        return this.query;
    }

    @EventField
    public Long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    @EventField
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @EventField
    public DateTime getExecutionStartTime() {
        return this.executionStartTime;
    }

    @EventField
    public DateTime getEndTime() {
        return this.endTime;
    }

    @EventField
    public Long getQueryWallTimeMs() {
        if (this.createTime == null || this.endTime == null) {
            return null;
        }
        return this.endTime.getMillis() - this.createTime.getMillis();
    }

    @EventField
    public Long getQueuedTimeMs() {
        return this.queuedTimeMs;
    }

    @EventField
    public Long getAnalysisTimeMs() {
        return this.analysisTimeMs;
    }

    @EventField
    public Long getDistributedPlanningTimeMs() {
        return this.distributedPlanningTimeMs;
    }

    @EventField
    public Long getTotalSplitWallTimeMs() {
        return this.totalSplitWallTimeMs;
    }

    @EventField
    public Long getTotalSplitCpuTimeMs() {
        return this.totalSplitCpuTimeMs;
    }

    @EventField
    public Long getBytesPerSec() {
        Long queryWallTimeMs = this.getQueryWallTimeMs();
        if (this.totalBytes == null || queryWallTimeMs == null) {
            return null;
        }
        return this.totalBytes * 1000L / (queryWallTimeMs + 1L);
    }

    @EventField
    public Long getBytesPerCpuSec() {
        if (this.totalBytes == null || this.totalSplitCpuTimeMs == null) {
            return null;
        }
        return this.totalBytes * 1000L / (this.totalSplitCpuTimeMs + 1L);
    }

    @EventField
    public Long getTotalBytes() {
        return this.totalBytes;
    }

    @EventField
    public Long getRowsPerSec() {
        Long queryWallTimeMs = this.getQueryWallTimeMs();
        if (this.totalRows == null || queryWallTimeMs == null) {
            return null;
        }
        return this.totalRows * 1000L / (queryWallTimeMs + 1L);
    }

    @EventField
    public Long getRowsPerCpuSec() {
        if (this.totalRows == null || this.totalSplitCpuTimeMs == null) {
            return null;
        }
        return this.totalRows * 1000L / (this.totalSplitCpuTimeMs + 1L);
    }

    @EventField
    public Long getTotalRows() {
        return this.totalRows;
    }

    @EventField
    public Integer getSplits() {
        return this.splits;
    }

    @EventField
    public Integer getErrorCode() {
        return this.errorCode == null ? null : Integer.valueOf(this.errorCode.getCode());
    }

    @EventField
    public String getErrorCodeName() {
        return this.errorCode == null ? null : this.errorCode.getName();
    }

    @EventField
    public String getFailureType() {
        return this.failureType;
    }

    @EventField
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @EventField
    public String getFailureTask() {
        return this.failureTask;
    }

    @EventField
    public String getFailureHost() {
        return this.failureHost;
    }

    @EventField
    public String getOutputStageJson() {
        return this.outputStageJson;
    }

    @EventField
    public String getFailuresJson() {
        return this.failuresJson;
    }

    @EventField
    public String getInputsJson() {
        return this.inputsJson;
    }

    @EventField
    public String getSessionPropertiesJson() {
        return this.sessionPropertiesJson;
    }
}

