/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.discovery;

import com.facebook.presto.discovery.EmbeddedDiscoveryConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceInventory;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.server.DiscoveryConfig;
import io.airlift.discovery.server.DynamicAnnouncementResource;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.ForDynamicStore;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.ReplicatedDynamicStore;
import io.airlift.discovery.server.Service;
import io.airlift.discovery.server.ServiceResource;
import io.airlift.discovery.server.StaticStore;
import io.airlift.discovery.store.InMemoryStore;
import io.airlift.discovery.store.ReplicatedStoreModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.node.NodeInfo;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class EmbeddedDiscoveryModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        if (!((EmbeddedDiscoveryConfig)this.buildConfigObject(EmbeddedDiscoveryConfig.class)).isEnabled()) {
            return;
        }
        ConfigBinder.configBinder((Binder)binder).bindConfig(DiscoveryConfig.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServiceResource.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("discovery");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Service.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(Service.class);
        binder.bind(ServiceSelector.class).to(DiscoveryServiceSelector.class);
        binder.bind(StaticStore.class).to(EmptyStaticStore.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(DynamicAnnouncementResource.class);
        binder.bind(DynamicStore.class).to(ReplicatedDynamicStore.class).in(Scopes.SINGLETON);
        binder.install((Module)new ReplicatedStoreModule("dynamic", ForDynamicStore.class, InMemoryStore.class));
    }

    private static class EmptyStaticStore
    implements StaticStore {
        private EmptyStaticStore() {
        }

        public void put(Service service) {
            throw new UnsupportedOperationException();
        }

        public void delete(Id<Service> id) {
            throw new UnsupportedOperationException();
        }

        public Set<Service> getAll() {
            return ImmutableSet.of();
        }

        public Set<Service> get(String type) {
            return ImmutableSet.of();
        }

        public Set<Service> get(String type, String pool) {
            return ImmutableSet.of();
        }
    }

    private static class DiscoveryServiceSelector
    implements ServiceSelector {
        private final NodeInfo nodeInfo;
        private final ServiceInventory inventory;

        @Inject
        public DiscoveryServiceSelector(NodeInfo nodeInfo, ServiceInventory inventory) {
            this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
            this.inventory = (ServiceInventory)Preconditions.checkNotNull((Object)inventory, (Object)"inventory is null");
        }

        public String getType() {
            return "discovery";
        }

        public String getPool() {
            return this.nodeInfo.getPool();
        }

        public List<ServiceDescriptor> selectAllServices() {
            return ImmutableList.copyOf((Iterable)this.inventory.getServiceDescriptors(this.getType()));
        }

        public ListenableFuture<List<ServiceDescriptor>> refresh() {
            this.inventory.updateServiceInventory();
            return Futures.immediateFuture(this.selectAllServices());
        }
    }
}

