/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;

public class TablePropertiesSystemTable
implements SystemTable {
    public static final SchemaTableName TABLE_PROPERTIES_TABLE_NAME = new SchemaTableName("metadata", "table_properties");
    public static final ConnectorTableMetadata TABLE_PROPERTIES_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_PROPERTIES_TABLE_NAME).column("catalog_name", (Type)VarcharType.VARCHAR).column("property_name", (Type)VarcharType.VARCHAR).column("default_value", (Type)VarcharType.VARCHAR).column("type", (Type)VarcharType.VARCHAR).column("description", (Type)VarcharType.VARCHAR).build();
    private final Metadata metadata;

    @Inject
    public TablePropertiesSystemTable(Metadata metadata) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata);
    }

    public boolean isDistributed() {
        return false;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TABLE_PROPERTIES_TABLE;
    }

    public RecordCursor cursor() {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)TABLE_PROPERTIES_TABLE);
        TreeMap tableProperties = new TreeMap(this.metadata.getTablePropertyManager().getAllTableProperties());
        for (Map.Entry entry : tableProperties.entrySet()) {
            String catalog = (String)entry.getKey();
            TreeMap properties = new TreeMap((Map)entry.getValue());
            for (PropertyMetadata propertyMetadata : properties.values()) {
                table.addRow(new Object[]{catalog, propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()});
            }
        }
        return table.build().cursor();
    }
}

