/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.connector.system.SystemTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class SystemSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final Map<SchemaTableName, SystemTable> tables;

    public SystemSplitManager(NodeManager nodeManager, Set<SystemTable> tables) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.tables = Maps.uniqueIndex(tables, table -> table.getTableMetadata().getTable());
    }

    public ConnectorSplitSource getSplits(ConnectorSession session, ConnectorTableLayoutHandle layout) {
        SystemTableLayoutHandle layoutHandle = Types.checkType(layout, SystemTableLayoutHandle.class, "layout");
        SystemTableHandle tableHandle = layoutHandle.getTable();
        SystemTable systemTable = this.tables.get(tableHandle.getSchemaTableName());
        if (systemTable.isDistributed()) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (Node node : this.nodeManager.getActiveNodes()) {
                splits.add((Object)new SystemSplit(tableHandle, node.getHostAndPort()));
            }
            return new FixedSplitSource("system", (Iterable)splits.build());
        }
        HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
        SystemSplit split = new SystemSplit(tableHandle, address);
        return new FixedSplitSource("system", (Iterable)ImmutableList.of((Object)split));
    }
}

