/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SystemRecordSetProvider
implements ConnectorRecordSetProvider {
    private final Map<SchemaTableName, SystemTable> tables;

    public SystemRecordSetProvider(Set<SystemTable> tables) {
        this.tables = Maps.uniqueIndex(tables, table -> table.getTableMetadata().getTable());
    }

    public RecordSet getRecordSet(ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        SchemaTableName tableName = Types.checkType(split, SystemSplit.class, "split").getTableHandle().getSchemaTableName();
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        SystemTable systemTable = this.tables.get(tableName);
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        List tableColumns = systemTable.getTableMetadata().getColumns();
        HashMap<String, Integer> columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < tableColumns.size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableColumns.get(i);
            if (columnsByName.put(column.getName(), i) == null) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Duplicate column name: " + column.getName());
        }
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = Types.checkType(columnHandle, SystemColumnHandle.class, "column").getColumnName();
            Integer index = (Integer)columnsByName.get(columnName);
            if (index == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Column does not exist: %s.%s", tableName, columnName));
            }
            userToSystemFieldIndex.add((Object)index);
        }
        return new MappedRecordSet((RecordSet)systemTable, (List<Integer>)userToSystemFieldIndex.build());
    }
}

