/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public class InvokeInstruction
implements InstructionNode {
    private final OpCode opCode;
    private final ParameterizedType target;
    private final String name;
    private final ParameterizedType returnType;
    private final List<ParameterizedType> parameterTypes;

    public static InstructionNode invokeStatic(Method method) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, method);
    }

    public static InstructionNode invokeStatic(MethodDefinition method) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, method);
    }

    public static InstructionNode invokeStatic(Class<?> target, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, target, name, returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeStatic(Class<?> target, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeStatic(ParameterizedType target, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, target, name, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeStatic(ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESTATIC, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeVirtual(Method method) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, method);
    }

    public static InstructionNode invokeVirtual(MethodDefinition method) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, method);
    }

    public static InstructionNode invokeVirtual(Class<?> target, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, target, name, returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeVirtual(Class<?> target, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeVirtual(ParameterizedType target, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, target, name, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeVirtual(ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEVIRTUAL, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeInterface(Method method) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, method);
    }

    public static InstructionNode invokeInterface(MethodDefinition method) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, method);
    }

    public static InstructionNode invokeInterface(Class<?> target, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, target, name, returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeInterface(Class<?> target, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeInterface(ParameterizedType target, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, target, name, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeInterface(ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKEINTERFACE, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeConstructor(Constructor<?> constructor) {
        return InvokeInstruction.invokeConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes());
    }

    public static InstructionNode invokeConstructor(Class<?> target, Class<?> ... parameterTypes) {
        return InvokeInstruction.invokeConstructor(ParameterizedType.type(target), Iterables.transform((Iterable)ImmutableList.copyOf((Object[])parameterTypes), ParameterizedType::type));
    }

    public static InstructionNode invokeConstructor(Class<?> target, Iterable<Class<?>> parameterTypes) {
        return InvokeInstruction.invokeConstructor(ParameterizedType.type(target), Iterables.transform(parameterTypes, ParameterizedType::type));
    }

    public static InstructionNode invokeConstructor(ParameterizedType target, ParameterizedType ... parameterTypes) {
        return InvokeInstruction.invokeConstructor(target, (Iterable<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeConstructor(ParameterizedType target, Iterable<ParameterizedType> parameterTypes) {
        return InvokeInstruction.invokeSpecial(target, "<init>", ParameterizedType.type(Void.TYPE), parameterTypes);
    }

    public static InstructionNode invokeSpecial(Method method) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, method);
    }

    public static InstructionNode invokeSpecial(MethodDefinition method) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, method);
    }

    public static InstructionNode invokeSpecial(Class<?> target, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, target, name, returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeSpecial(Class<?> target, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, target, name, returnType, parameterTypes);
    }

    public static InstructionNode invokeSpecial(ParameterizedType target, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, target, name, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static InstructionNode invokeSpecial(ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        return InvokeInstruction.invoke(OpCode.INVOKESPECIAL, target, name, returnType, parameterTypes);
    }

    private static InstructionNode invoke(OpCode invocationType, Method method) {
        return new InvokeInstruction(invocationType, ParameterizedType.type(method.getDeclaringClass()), method.getName(), ParameterizedType.type(method.getReturnType()), Iterables.transform((Iterable)ImmutableList.copyOf((Object[])method.getParameterTypes()), ParameterizedType::type));
    }

    private static InstructionNode invoke(OpCode invocationType, MethodDefinition method) {
        return new InvokeInstruction(invocationType, method.getDeclaringClass().getType(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    private static InstructionNode invoke(OpCode invocationType, ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        return new InvokeInstruction(invocationType, target, name, returnType, parameterTypes);
    }

    private static InstructionNode invoke(OpCode invocationType, Class<?> target, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        return new InvokeInstruction(invocationType, ParameterizedType.type(target), name, ParameterizedType.type(returnType), Iterables.transform(parameterTypes, ParameterizedType::type));
    }

    public static InstructionNode invokeDynamic(String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Method bootstrapMethod, Iterable<Object> bootstrapArguments) {
        return new InvokeDynamicInstruction(name, returnType, parameterTypes, bootstrapMethod, (List<Object>)ImmutableList.copyOf(bootstrapArguments));
    }

    public static InstructionNode invokeDynamic(String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Method bootstrapMethod, Object ... bootstrapArguments) {
        return new InvokeDynamicInstruction(name, returnType, parameterTypes, bootstrapMethod, (List<Object>)ImmutableList.copyOf((Object[])bootstrapArguments));
    }

    public static InstructionNode invokeDynamic(String name, MethodType methodType, Method bootstrapMethod, Iterable<Object> bootstrapArguments) {
        return new InvokeDynamicInstruction(name, ParameterizedType.type(methodType.returnType()), Iterables.transform(methodType.parameterList(), ParameterizedType::type), bootstrapMethod, (List<Object>)ImmutableList.copyOf(bootstrapArguments));
    }

    public static InstructionNode invokeDynamic(String name, MethodType methodType, Method bootstrapMethod, Object ... bootstrapArguments) {
        return new InvokeDynamicInstruction(name, ParameterizedType.type(methodType.returnType()), Iterables.transform(methodType.parameterList(), ParameterizedType::type), bootstrapMethod, (List<Object>)ImmutableList.copyOf((Object[])bootstrapArguments));
    }

    public InvokeInstruction(OpCode opCode, ParameterizedType target, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        InvokeInstruction.checkUnqualifiedName(name);
        this.opCode = opCode;
        this.target = target;
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public ParameterizedType getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getReturnType() {
        return this.returnType;
    }

    public List<ParameterizedType> getParameterTypes() {
        return this.parameterTypes;
    }

    public String getMethodDescription() {
        return MethodDefinition.methodDescription(this.returnType, this.parameterTypes);
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        visitor.visitMethodInsn(this.opCode.getOpCode(), this.target.getClassName(), this.name, this.getMethodDescription());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitInvoke(parent, this);
    }

    private static void checkUnqualifiedName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return;
        }
        CharMatcher invalid = CharMatcher.anyOf((CharSequence)".;[/<>");
        Preconditions.checkArgument((boolean)invalid.matchesNoneOf((CharSequence)name), (String)"invalid name: %s", (Object[])new Object[]{name});
    }

    public static class InvokeDynamicInstruction
    extends InvokeInstruction {
        private final Method bootstrapMethod;
        private final List<Object> bootstrapArguments;

        public InvokeDynamicInstruction(String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Method bootstrapMethod, List<Object> bootstrapArguments) {
            super(OpCode.INVOKEDYNAMIC, null, name, returnType, parameterTypes);
            this.bootstrapMethod = bootstrapMethod;
            this.bootstrapArguments = ImmutableList.copyOf(bootstrapArguments);
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            Handle bootstrapMethodHandle = new Handle(6, ParameterizedType.type(this.bootstrapMethod.getDeclaringClass()).getClassName(), this.bootstrapMethod.getName(), MethodDefinition.methodDescription(this.bootstrapMethod.getReturnType(), this.bootstrapMethod.getParameterTypes()));
            visitor.visitInvokeDynamicInsn(this.getName(), this.getMethodDescription(), bootstrapMethodHandle, this.bootstrapArguments.toArray(new Object[this.bootstrapArguments.size()]));
        }

        public Method getBootstrapMethod() {
            return this.bootstrapMethod;
        }

        public List<Object> getBootstrapArguments() {
            return this.bootstrapArguments;
        }

        @Override
        public List<ByteCodeNode> getChildNodes() {
            return ImmutableList.of();
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitInvokeDynamic(parent, this);
        }
    }
}

