/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class Constant
implements InstructionNode {
    public static Constant loadNull() {
        return new NullConstant();
    }

    public static Constant loadBoolean(boolean value) {
        return new BooleanConstant(value);
    }

    public static Constant loadBoxedBoolean(boolean value) {
        return new BoxedBooleanConstant(value);
    }

    public static Constant loadInt(int value) {
        return new IntConstant(value);
    }

    public static Constant loadBoxedInt(int value) {
        return new BoxedIntegerConstant(value);
    }

    public static Constant loadFloat(float value) {
        return new FloatConstant(value);
    }

    public static Constant loadBoxedFloat(float value) {
        return new BoxedFloatConstant(value);
    }

    public static Constant loadLong(long value) {
        return new LongConstant(value);
    }

    public static Constant loadBoxedLong(long value) {
        return new BoxedLongConstant(value);
    }

    public static Constant loadDouble(double value) {
        return new DoubleConstant(value);
    }

    public static Constant loadBoxedDouble(double value) {
        return new BoxedDoubleConstant(value);
    }

    public static Constant loadNumber(Number value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        if (value instanceof Byte) {
            return Constant.loadInt(value.intValue());
        }
        if (value instanceof Short) {
            return Constant.loadInt(value.intValue());
        }
        if (value instanceof Integer) {
            return Constant.loadInt((Integer)value);
        }
        if (value instanceof Long) {
            return Constant.loadLong((Long)value);
        }
        if (value instanceof Float) {
            return Constant.loadFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Constant.loadDouble((Double)value);
        }
        throw new IllegalStateException("Unsupported number type " + value.getClass().getSimpleName());
    }

    public static Constant loadString(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new StringConstant(value);
    }

    public static Constant loadClass(Class<?> value) {
        Preconditions.checkNotNull(value, (Object)"value is null");
        return new ClassConstant(ParameterizedType.type(value));
    }

    public static Constant loadClass(ParameterizedType value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new ClassConstant(value);
    }

    public abstract Object getValue();

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitConstant(parent, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.getValue()).toString();
    }

    public static class ClassConstant
    extends Constant {
        private final ParameterizedType value;

        private ClassConstant(ParameterizedType value) {
            this.value = value;
        }

        @Override
        public ParameterizedType getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (this.value.isPrimitive()) {
                Class wrapper = Primitives.wrap(this.value.getPrimitiveType());
                FieldInstruction.getStaticInstruction(wrapper, "TYPE", Class.class).accept(visitor, generationContext);
            } else {
                visitor.visitLdcInsn((Object)Type.getType((String)this.value.getType()));
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitClassConstant(parent, this);
        }
    }

    public static class StringConstant
    extends Constant {
        private final String value;

        private StringConstant(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            visitor.visitLdcInsn((Object)this.value);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitStringConstant(parent, this);
        }
    }

    public static class BoxedDoubleConstant
    extends Constant {
        private final double value;

        private BoxedDoubleConstant(double value) {
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            BoxedDoubleConstant.loadDouble(this.value).accept(visitor, generationContext);
            InvokeInstruction.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE).accept(visitor, generationContext);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedDoubleConstant(parent, this);
        }
    }

    public static class DoubleConstant
    extends Constant {
        private final double value;

        private DoubleConstant(double value) {
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(0.0)) {
                visitor.visitInsn(OpCode.DCONST_0.getOpCode());
            } else if (this.value == 1.0) {
                visitor.visitInsn(OpCode.DCONST_1.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitDoubleConstant(parent, this);
        }
    }

    public static class BoxedLongConstant
    extends Constant {
        private final long value;

        private BoxedLongConstant(long value) {
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            BoxedLongConstant.loadLong(this.value).accept(visitor, generationContext);
            InvokeInstruction.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE).accept(visitor, generationContext);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedLongConstant(parent, this);
        }
    }

    public static class LongConstant
    extends Constant {
        private final long value;

        private LongConstant(long value) {
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (this.value == 0L) {
                visitor.visitInsn(OpCode.LCONST_0.getOpCode());
            } else if (this.value == 1L) {
                visitor.visitInsn(OpCode.LCONST_1.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitLongConstant(parent, this);
        }
    }

    public static class BoxedFloatConstant
    extends Constant {
        private final float value;

        private BoxedFloatConstant(float value) {
            this.value = value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            BoxedFloatConstant.loadFloat(this.value).accept(visitor, generationContext);
            InvokeInstruction.invokeStatic(Float.class, "valueOf", Float.class, Float.TYPE).accept(visitor, generationContext);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedFloatConstant(parent, this);
        }
    }

    public static class FloatConstant
    extends Constant {
        private final float value;

        private FloatConstant(float value) {
            this.value = value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (Float.floatToIntBits(this.value) == Float.floatToIntBits(0.0f)) {
                visitor.visitInsn(OpCode.FCONST_0.getOpCode());
            } else if (this.value == 1.0f) {
                visitor.visitInsn(OpCode.FCONST_1.getOpCode());
            } else if (this.value == 2.0f) {
                visitor.visitInsn(OpCode.FCONST_2.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)Float.valueOf(this.value));
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitFloatConstant(parent, this);
        }
    }

    public static class BoxedIntegerConstant
    extends Constant {
        private final int value;

        private BoxedIntegerConstant(int value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            BoxedIntegerConstant.loadInt(this.value).accept(visitor, generationContext);
            InvokeInstruction.invokeStatic(Integer.class, "valueOf", Integer.class, Integer.TYPE).accept(visitor, generationContext);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedIntegerConstant(parent, this);
        }
    }

    public static class IntConstant
    extends Constant {
        private final int value;

        private IntConstant(int value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (this.value <= 127 && this.value >= -128) {
                switch (this.value) {
                    case -1: {
                        visitor.visitInsn(OpCode.ICONST_M1.getOpCode());
                        break;
                    }
                    case 0: {
                        visitor.visitInsn(OpCode.ICONST_0.getOpCode());
                        break;
                    }
                    case 1: {
                        visitor.visitInsn(OpCode.ICONST_1.getOpCode());
                        break;
                    }
                    case 2: {
                        visitor.visitInsn(OpCode.ICONST_2.getOpCode());
                        break;
                    }
                    case 3: {
                        visitor.visitInsn(OpCode.ICONST_3.getOpCode());
                        break;
                    }
                    case 4: {
                        visitor.visitInsn(OpCode.ICONST_4.getOpCode());
                        break;
                    }
                    case 5: {
                        visitor.visitInsn(OpCode.ICONST_5.getOpCode());
                        break;
                    }
                    default: {
                        visitor.visitIntInsn(OpCode.BIPUSH.getOpCode(), this.value);
                        break;
                    }
                }
            } else if (this.value <= Short.MAX_VALUE && this.value >= Short.MIN_VALUE) {
                visitor.visitIntInsn(OpCode.SIPUSH.getOpCode(), this.value);
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitIntConstant(parent, this);
        }
    }

    public static class BoxedBooleanConstant
    extends Constant {
        private final boolean value;

        private BoxedBooleanConstant(boolean value) {
            this.value = value;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (this.value) {
                FieldInstruction.getStaticInstruction(Boolean.class, "TRUE", Boolean.class).accept(visitor, generationContext);
            } else {
                FieldInstruction.getStaticInstruction(Boolean.class, "FALSE", Boolean.class).accept(visitor, generationContext);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedBooleanConstant(parent, this);
        }
    }

    public static class BooleanConstant
    extends Constant {
        private final boolean value;

        private BooleanConstant(boolean value) {
            this.value = value;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            if (this.value) {
                visitor.visitInsn(OpCode.ICONST_1.getOpCode());
            } else {
                visitor.visitInsn(OpCode.ICONST_0.getOpCode());
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBooleanConstant(parent, this);
        }
    }

    public static class NullConstant
    extends Constant {
        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            visitor.visitInsn(OpCode.ACONST_NULL.getOpCode());
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitConstant(parent, this);
        }
    }
}

