/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class InlineIfByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression condition;
    private final ByteCodeExpression ifTrue;
    private final ByteCodeExpression ifFalse;

    InlineIfByteCodeExpression(ByteCodeExpression condition, ByteCodeExpression ifTrue, ByteCodeExpression ifFalse) {
        super(ifTrue.getType());
        this.condition = condition;
        this.ifTrue = (ByteCodeExpression)Preconditions.checkNotNull((Object)ifTrue, (Object)"ifTrue is null");
        this.ifFalse = (ByteCodeExpression)Preconditions.checkNotNull((Object)ifFalse, (Object)"ifFalse is null");
        Preconditions.checkArgument((condition.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected condition to be type boolean but is %s", (Object[])new Object[]{condition.getType()});
        Preconditions.checkArgument((boolean)ifTrue.getType().equals(ifFalse.getType()), (Object)"Expected ifTrue and ifFalse to be the same type");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        return new Block().append(this.condition).ifFalseGoto(falseLabel).append(this.ifTrue).gotoLabel(endLabel).visitLabel(falseLabel).append(this.ifFalse).visitLabel(endLabel);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.ifTrue, (Object)this.ifFalse);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.condition + " ? " + this.ifTrue + " : " + this.ifFalse + ")";
    }
}

