/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;

class GetFieldByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;

    public GetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Class<?> declaringClass, String name) {
        this(instance, GetFieldByteCodeExpression.getDeclaredField(declaringClass, name));
    }

    public GetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, Field field) {
        this(instance, ParameterizedType.type(((Field)Preconditions.checkNotNull((Object)field, (Object)"field is null")).getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            Preconditions.checkArgument((boolean)isStatic, (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!isStatic ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public GetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, FieldDefinition field) {
        this(instance, ((FieldDefinition)Preconditions.checkNotNull((Object)field, (Object)"field is null")).getDeclaringClass().getType(), field.getName(), field.getType());
        if (instance == null) {
            Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        } else {
            Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        }
    }

    public GetFieldByteCodeExpression(@Nullable ByteCodeExpression instance, ParameterizedType declaringClass, String name, ParameterizedType type) {
        super(type);
        Preconditions.checkArgument((instance == null || !instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have fields", (Object[])new Object[]{this.getType()});
        this.instance = instance;
        this.declaringClass = (ParameterizedType)Preconditions.checkNotNull((Object)declaringClass, (Object)"declaringClass is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return FieldInstruction.getStaticInstruction(this.declaringClass, this.name, this.getType());
        }
        return new Block().append(this.instance.getByteCode(generationContext)).getField(this.declaringClass, this.name, this.getType());
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name;
        }
        return this.instance + "." + this.name;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return this.instance == null ? ImmutableList.of() : ImmutableList.of((Object)this.instance);
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Preconditions.checkNotNull(declaringClass, (Object)"declaringClass is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

