/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class GetElementByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final ByteCodeExpression index;
    private final InstructionNode arrayLoadInstruction;

    public GetElementByteCodeExpression(ByteCodeExpression instance, ByteCodeExpression index) {
        super(instance.getType().getArrayComponentType());
        this.instance = (ByteCodeExpression)Preconditions.checkNotNull((Object)instance, (Object)"instance is null");
        this.index = (ByteCodeExpression)Preconditions.checkNotNull((Object)index, (Object)"index is null");
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        this.arrayLoadInstruction = GetElementByteCodeExpression.arrayLoadInstruction(instance.getType().getArrayComponentType());
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return new Block().append(this.instance.getByteCode(generationContext)).append(this.index).append(this.arrayLoadInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "]";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance, (Object)this.index);
    }

    private static InstructionNode arrayLoadInstruction(ParameterizedType componentType) {
        Class<?> primitiveType = componentType.getPrimitiveType();
        if (primitiveType == null) {
            return OpCode.AALOAD;
        }
        if (primitiveType == Byte.TYPE || primitiveType == Boolean.TYPE) {
            return OpCode.BALOAD;
        }
        if (primitiveType == Character.TYPE) {
            return OpCode.CALOAD;
        }
        if (primitiveType == Short.TYPE) {
            return OpCode.SALOAD;
        }
        if (primitiveType == Integer.TYPE) {
            return OpCode.IALOAD;
        }
        if (primitiveType == Long.TYPE) {
            return OpCode.LALOAD;
        }
        if (primitiveType == Float.TYPE) {
            return OpCode.FALOAD;
        }
        if (primitiveType == Double.TYPE) {
            return OpCode.DALOAD;
        }
        throw new IllegalArgumentException("Unsupported array type: " + primitiveType);
    }
}

