/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;

class CastByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;

    public CastByteCodeExpression(ByteCodeExpression instance, ParameterizedType type) {
        super(type);
        this.instance = (ByteCodeExpression)Preconditions.checkNotNull((Object)instance, (Object)"instance is null");
        Preconditions.checkArgument((type.getPrimitiveType() != Void.TYPE ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object[])new Object[]{instance.getType(), type});
        if (instance.getType().isPrimitive() != type.isPrimitive()) {
            Preconditions.checkArgument((CastByteCodeExpression.unwrapPrimitiveType(instance.getType()) == CastByteCodeExpression.unwrapPrimitiveType(type) ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object[])new Object[]{instance.getType(), type});
        }
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        Block block = new Block().append(this.instance.getByteCode(generationContext));
        if (this.instance.getType().isPrimitive()) {
            Class<?> sourceType = this.instance.getType().getPrimitiveType();
            CastByteCodeExpression.castPrimitiveToPrimitive(block, sourceType, CastByteCodeExpression.unwrapPrimitiveType(this.getType()));
            if (!this.getType().isPrimitive()) {
                Class<?> primitiveTargetType = CastByteCodeExpression.unwrapPrimitiveType(this.getType());
                return block.invokeStatic(this.getType(), "valueOf", this.getType(), ParameterizedType.type(primitiveTargetType));
            }
            return block;
        }
        if (this.getType().isPrimitive()) {
            Class<?> targetType = this.getType().getPrimitiveType();
            return block.invokeVirtual(Primitives.wrap(targetType), targetType.getSimpleName() + "Value", targetType, new Class[0]);
        }
        block.checkCast(this.getType());
        return block;
    }

    private static Block castPrimitiveToPrimitive(Block block, Class<?> sourceType, Class<?> targetType) {
        if (sourceType == Byte.TYPE) {
            if (targetType == Byte.TYPE) {
                return block;
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Character.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Short.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Integer.TYPE) {
            if (targetType == Boolean.TYPE) {
                return block;
            }
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Long.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.L2I);
            }
            if (targetType == Long.TYPE) {
                return block;
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.L2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.L2D);
            }
        }
        if (sourceType == Float.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.F2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.F2L);
            }
            if (targetType == Float.TYPE) {
                return block;
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.F2D);
            }
        }
        if (sourceType == Double.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.D2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.D2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.D2F);
            }
            if (targetType == Double.TYPE) {
                return block;
            }
        }
        throw new IllegalArgumentException(String.format("Type %s can not be cast to %s", sourceType, targetType));
    }

    private static Class<?> unwrapPrimitiveType(ParameterizedType type) {
        if (type.isPrimitive()) {
            return type.getPrimitiveType();
        }
        switch (type.getJavaClassName()) {
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    @Override
    protected String formatOneLine() {
        return "((" + this.getType().getSimpleName() + ") " + this.instance + ")";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }
}

