/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class ForLoop
implements FlowControl {
    private final String comment;
    private final Block initialize = new Block();
    private final Block condition = new Block();
    private final Block update = new Block();
    private final Block body = new Block();
    private final LabelNode beginLabel = new LabelNode("beginLabel");
    private final LabelNode continueLabel = new LabelNode("continue");
    private final LabelNode endLabel = new LabelNode("end");

    public ForLoop() {
        this.comment = null;
    }

    public ForLoop(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public LabelNode getContinueLabel() {
        return this.continueLabel;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    public Block initialize() {
        return this.initialize;
    }

    public ForLoop initialize(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.initialize.isEmpty(), (Object)"initialize already set");
        this.initialize.append(node);
        return this;
    }

    public Block condition() {
        return this.condition;
    }

    public ForLoop condition(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.condition.isEmpty(), (Object)"condition already set");
        this.condition.append(node);
        return this;
    }

    public Block update() {
        return this.update;
    }

    public ForLoop update(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.update.isEmpty(), (Object)"update already set");
        this.update.append(node);
        return this;
    }

    public Block body() {
        return this.body;
    }

    public ForLoop body(ByteCodeNode node) {
        Preconditions.checkState((boolean)this.body.isEmpty(), (Object)"body already set");
        this.body.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        Preconditions.checkState((!this.condition.isEmpty() ? 1 : 0) != 0, (Object)"ForLoop does not have a condition set");
        Block block = new Block();
        block.append(new Block().setDescription("initialize").append(this.initialize));
        block.visitLabel(this.beginLabel).append(new Block().setDescription("condition").append(this.condition)).ifFalseGoto(this.endLabel);
        block.append(new Block().setDescription("body").append(this.body));
        block.visitLabel(this.continueLabel).append(new Block().setDescription("update").append(this.update)).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor, generationContext);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.initialize, (Object)this.condition, (Object)this.update, (Object)this.body);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitFor(parent, this);
    }
}

