/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Variable
extends ByteCodeExpression {
    private final String name;

    public Variable(String name, ParameterizedType type) {
        super(type);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
    }

    public String getName() {
        return this.name;
    }

    public ByteCodeExpression set(ByteCodeExpression value) {
        return new SetVariableByteCodeExpression(this, value);
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        return VariableInstruction.loadVariable(this);
    }

    @Override
    protected String formatOneLine() {
        return this.name;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    private static final class SetVariableByteCodeExpression
    extends ByteCodeExpression {
        private final Variable variable;
        private final ByteCodeExpression value;

        public SetVariableByteCodeExpression(Variable variable, ByteCodeExpression value) {
            super(ParameterizedType.type(Void.TYPE));
            this.variable = (Variable)Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
            this.value = (ByteCodeExpression)Preconditions.checkNotNull((Object)value, (Object)"value is null");
        }

        @Override
        public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
            return new Block().append(this.value).putVariable(this.variable);
        }

        @Override
        public List<ByteCodeNode> getChildNodes() {
            return ImmutableList.of((Object)this.value);
        }

        @Override
        protected String formatOneLine() {
            return this.variable.getName() + " = " + this.value;
        }
    }
}

