/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public final class SystemSessionProperties {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String DISTRIBUTED_JOIN = "distributed_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_DEFAULT_CONCURRENCY = "task_default_concurrency";
    public static final String TASK_JOIN_CONCURRENCY = "task_join_concurrency";
    public static final String TASK_HASH_BUILD_CONCURRENCY = "task_hash_build_concurrency";
    public static final String TASK_AGGREGATION_CONCURRENCY = "task_aggregation_concurrency";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanSessionProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)featuresConfig.isOptimizeHashGeneration(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)DISTRIBUTED_JOIN, (String)"Use a distributed join instead of a broadcast join", (Boolean)featuresConfig.isDistributedJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getInitialHashPartitions(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_WRITER_COUNT, (String)"Default number of local parallel table writer jobs per worker", (Integer)taskManagerConfig.getWriterCount(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_DEFAULT_CONCURRENCY, (String)"Experimental: Default number of local parallel jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_JOIN_CONCURRENCY, (String)"Experimental: Default number of local parallel join jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_HASH_BUILD_CONCURRENCY, (String)"Experimental: Default number of local parallel hash build jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_AGGREGATION_CONCURRENCY, (String)"Experimental: Default number of local parallel aggregation jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object)new PropertyMetadata(QUERY_MAX_MEMORY, "Maximum amount of distributed memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getMaxQueryMemory(), true, value -> DataSize.valueOf((String)((String)value))));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static boolean isDistributedJoinEnabled(Session session) {
        return session.getProperty(DISTRIBUTED_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static int getTaskJoinConcurrency(Session session) {
        return SystemSessionProperties.getPropertyOr(session, TASK_JOIN_CONCURRENCY, TASK_DEFAULT_CONCURRENCY, Integer.class);
    }

    public static int getTaskHashBuildConcurrency(Session session) {
        return SystemSessionProperties.getPropertyOr(session, TASK_HASH_BUILD_CONCURRENCY, TASK_DEFAULT_CONCURRENCY, Integer.class);
    }

    public static int getTaskAggregationConcurrency(Session session) {
        return SystemSessionProperties.getPropertyOr(session, TASK_AGGREGATION_CONCURRENCY, TASK_DEFAULT_CONCURRENCY, Integer.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    private static <T> T getPropertyOr(Session session, String propertyName, String defaultPropertyName, Class<T> type) {
        T value = session.getProperty(propertyName, type);
        if (value == null) {
            value = session.getProperty(defaultPropertyName, type);
        }
        return value;
    }
}

