/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;

public final class Session {
    private final String user;
    private final Optional<String> source;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final SessionPropertyManager sessionPropertyManager;

    public Session(String user, Optional<String> source, String catalog, String schema, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, long startTime, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogProperties, SessionPropertyManager sessionPropertyManager) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = source;
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = remoteUserAddress;
        this.userAgent = userAgent;
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        catalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.catalogProperties = catalogPropertiesBuilder.build();
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public <T> T getProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeProperty(name, this.systemProperties.get(name), type);
    }

    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Map<String, String> getCatalogProperties(String catalog) {
        return this.catalogProperties.getOrDefault(catalog, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Session withSystemProperty(String key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        LinkedHashMap<String, String> systemProperties = new LinkedHashMap<String, String>(this.systemProperties);
        systemProperties.put(key, value);
        return new Session(this.user, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, systemProperties, this.catalogProperties, this.sessionPropertyManager);
    }

    public Session withCatalogProperty(String catalog, String key, String value) {
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        LinkedHashMap<String, Map<String, String>> catalogProperties = new LinkedHashMap<String, Map<String, String>>(this.catalogProperties);
        LinkedHashMap<String, String> properties = (LinkedHashMap<String, String>)catalogProperties.get(catalog);
        properties = properties == null ? new LinkedHashMap<String, String>() : new LinkedHashMap(properties);
        properties.put(key, value);
        catalogProperties.put(catalog, properties);
        return new Session(this.user, this.source, catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, catalogProperties, this.sessionPropertyManager);
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this.user, this.timeZoneKey, this.locale, this.startTime);
    }

    public ConnectorSession toConnectorSession(String catalog) {
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        return new FullConnectorSession(this.user, this.timeZoneKey, this.locale, this.startTime, this.catalogProperties.getOrDefault(catalog, (Map<String, String>)ImmutableMap.of()), catalog, this.sessionPropertyManager);
    }

    public ClientSession toClientSession(URI server, boolean debug) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(this.systemProperties);
        for (Map.Entry<String, Map<String, String>> catalogProperties : this.catalogProperties.entrySet()) {
            String catalog = catalogProperties.getKey();
            for (Map.Entry<String, String> entry : catalogProperties.getValue().entrySet()) {
                properties.put((Object)(catalog + "." + entry.getKey()), (Object)entry.getValue());
            }
        }
        return new ClientSession((URI)Preconditions.checkNotNull((Object)server, (Object)"server is null"), this.user, (String)this.source.orElse(null), this.catalog, this.schema, this.timeZoneKey.getId(), this.locale, (Map)properties.build(), debug);
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.user, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user).add("source", this.source).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress).add("userAgent", this.userAgent).add("startTime", this.startTime).toString();
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    public static class SessionBuilder {
        private String user;
        private String source;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private long startTime = System.currentTimeMillis();
        private Map<String, String> systemProperties = ImmutableMap.of();
        private final Map<String, Map<String, String>> catalogProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = (SessionPropertyManager)Preconditions.checkNotNull((Object)sessionPropertyManager, (Object)"sessionPropertyManager is null");
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = ImmutableMap.copyOf(systemProperties);
            return this;
        }

        public SessionBuilder setCatalogProperties(String catalog, Map<String, String> properties) {
            Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
            Preconditions.checkArgument((!catalog.isEmpty() ? 1 : 0) != 0, (Object)"catalog is empty");
            this.catalogProperties.put(catalog, (Map<String, String>)ImmutableMap.copyOf(properties));
            return this;
        }

        public Session build() {
            return new Session(this.user, Optional.ofNullable(this.source), this.catalog, this.schema, this.timeZoneKey, this.locale, Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), this.startTime, this.systemProperties, this.catalogProperties, this.sessionPropertyManager);
        }
    }
}

