/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class PartitionedPagePartitionFunction
implements PagePartitionFunction {
    protected final int partition;
    protected final int partitionCount;

    @JsonCreator
    public PartitionedPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount) {
        Preconditions.checkArgument((partition < partitionCount ? 1 : 0) != 0, (Object)"partition must be less than partitionCount");
        this.partition = partition;
        this.partitionCount = partitionCount;
    }

    @Override
    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @Override
    @JsonProperty
    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.partitionCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionedPagePartitionFunction other = (PartitionedPagePartitionFunction)obj;
        return Objects.equals(this.partition, other.partition) && Objects.equals(this.partitionCount, other.partitionCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).toString();
    }
}

