/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PartitionedPagePartitionFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class HashPagePartitionFunction
extends PartitionedPagePartitionFunction {
    private final List<Integer> partitioningChannels;
    private final List<Type> types;
    private final Optional<Integer> hashChannel;
    private final PlanFragment.NullPartitioning nullPartitioning;

    @JsonCreator
    public HashPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="partitioningChannels") List<Integer> partitioningChannels, @JsonProperty(value="hashChannel") Optional<Integer> hashChannel, @JsonProperty(value="types") List<Type> types, @JsonProperty(value="nullPartitioning") PlanFragment.NullPartitioning nullPartitioning) {
        super(partition, partitionCount);
        Preconditions.checkNotNull(partitioningChannels, (Object)"partitioningChannels is null");
        Preconditions.checkArgument((!partitioningChannels.isEmpty() ? 1 : 0) != 0, (Object)"partitioningChannels is empty");
        this.hashChannel = (Optional)Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
        Preconditions.checkArgument((!hashChannel.isPresent() || hashChannel.get() < types.size() ? 1 : 0) != 0, (Object)"invalid hashChannel");
        Preconditions.checkArgument((nullPartitioning == PlanFragment.NullPartitioning.HASH || partitioningChannels.size() == 1 ? 1 : 0) != 0, (Object)"size of partitioningChannels is not 1 when nullPartition is REPLICATE.");
        this.partitioningChannels = ImmutableList.copyOf(partitioningChannels);
        this.types = ImmutableList.copyOf(types);
        this.nullPartitioning = nullPartitioning;
    }

    @JsonProperty
    public List<Integer> getPartitioningChannels() {
        return this.partitioningChannels;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public Optional<Integer> getHashChannel() {
        return this.hashChannel;
    }

    @JsonProperty
    public PlanFragment.NullPartitioning getNullPartitioning() {
        return this.nullPartitioning;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partition, this.partitionCount, this.partitioningChannels);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashPagePartitionFunction other = (HashPagePartitionFunction)obj;
        return Objects.equals(this.partition, other.partition) && Objects.equals(this.partitionCount, other.partitionCount) && Objects.equals(this.partitioningChannels, other.partitioningChannels) && Objects.equals(this.hashChannel, other.hashChannel);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).add("partitioningChannels", this.partitioningChannels).add("hashChannel", this.hashChannel).toString();
    }
}

