/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class FullConnectorSession
implements ConnectorSession {
    private final String user;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final long startTime;
    private final Map<String, String> properties;
    private final String catalog;
    private final SessionPropertyManager sessionPropertyManager;

    public FullConnectorSession(String user, TimeZoneKey timeZoneKey, Locale locale, long startTime) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = null;
        this.catalog = null;
        this.sessionPropertyManager = null;
    }

    public FullConnectorSession(String user, TimeZoneKey timeZoneKey, Locale locale, long startTime, Map<String, String> properties, String catalog, SessionPropertyManager sessionPropertyManager) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    public String getUser() {
        return this.user;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public <T> T getProperty(String name, Class<T> type) {
        if (this.properties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        return this.sessionPropertyManager.decodeProperty(this.catalog + "." + name, this.properties.get(name), type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("user", (Object)this.user).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("startTime", this.startTime).add("properties", this.properties).toString();
    }
}

