/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.units.DataSize;

public class ExceededMemoryLimitException
extends PrestoException {
    private final DataSize maxMemory;

    public ExceededMemoryLimitException(DataSize maxMemory) {
        this("Task", maxMemory);
    }

    public ExceededMemoryLimitException(String entity, DataSize maxMemory) {
        super((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_MEMORY_LIMIT, String.format("%s exceeded max memory size of %s", entity, maxMemory));
        this.maxMemory = maxMemory;
    }

    public DataSize getMaxMemory() {
        return this.maxMemory;
    }
}

