/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import com.facebook.presto.lark.sheets.LarkSheetsErrorCode;
import com.facebook.presto.lark.sheets.LarkSheetsUtil;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.SheetInfo;
import com.facebook.presto.lark.sheets.api.SheetValues;
import com.facebook.presto.lark.sheets.api.SpreadsheetInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.drive_permission.v2.DrivePermissionService;
import com.larksuite.oapi.service.drive_permission.v2.model.PublicGetReqBody;
import com.larksuite.oapi.service.sheets.v2.SheetsService;
import com.larksuite.oapi.service.sheets.v2.model.MetainfoProperties;
import com.larksuite.oapi.service.sheets.v2.model.Sheet;
import com.larksuite.oapi.service.sheets.v2.model.SpreadsheetsMetainfoResult;
import com.larksuite.oapi.service.sheets.v2.model.SpreadsheetsValuesGetResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SimpleLarkSheetsApi
implements LarkSheetsApi {
    private final DrivePermissionService drivePermissionService;
    private final SheetsService sheetsService;

    public SimpleLarkSheetsApi(DrivePermissionService drivePermissionService, SheetsService sheetsService) {
        this.drivePermissionService = Objects.requireNonNull(drivePermissionService, "drivePermissionService is null");
        this.sheetsService = Objects.requireNonNull(sheetsService, "sheetsService is null");
    }

    @Override
    public boolean isReadable(String token) {
        try {
            PublicGetReqBody request = new PublicGetReqBody();
            request.setType("sheet");
            request.setToken(token);
            Response response = this.drivePermissionService.getPublics().get(request, new RequestOptFn[0]).execute();
            return response.getCode() == 0;
        }
        catch (Exception e) {
            throw SimpleLarkSheetsApi.wrapApiError(e, "Could not check permission for spreadsheet " + LarkSheetsUtil.mask(token));
        }
    }

    @Override
    public SpreadsheetInfo getMetaInfo(String token) {
        SheetsService.SpreadsheetsMetainfoReqCall request = this.sheetsService.getSpreadsheetss().metainfo(new RequestOptFn[0]);
        request.setSpreadsheetToken(token);
        try {
            Response response = request.execute();
            SimpleLarkSheetsApi.checkResponse(response);
            SpreadsheetsMetainfoResult data = (SpreadsheetsMetainfoResult)response.getData();
            MetainfoProperties properties = data.getProperties();
            List sheets = (List)Arrays.stream(data.getSheets()).map(sheet -> SimpleLarkSheetsApi.toMetaInfoSheet(token, sheet)).collect(ImmutableList.toImmutableList());
            return new SpreadsheetInfo(data.getSpreadsheetToken(), properties.getTitle(), properties.getRevision().intValue(), sheets);
        }
        catch (Exception e) {
            throw SimpleLarkSheetsApi.wrapApiError(e, "Could not get metadata of spreadsheet " + LarkSheetsUtil.mask(token));
        }
    }

    @Override
    public List<String> getHeaderRow(String token, String sheetId, int columnCount) {
        String lastColumnLabel = LarkSheetsUtil.columnIndexToColumnLabel(columnCount - 1);
        String range = String.format("%s!A1:%s1", sheetId, lastColumnLabel);
        try {
            SheetsService.SpreadsheetsValuesGetReqCall request = this.sheetsService.getSpreadsheetss().valuesGet(new RequestOptFn[0]);
            request.setSpreadsheetToken(token);
            request.setRange(range);
            Response response = request.execute();
            SimpleLarkSheetsApi.checkResponse(response);
            SpreadsheetsValuesGetResult data = (SpreadsheetsValuesGetResult)response.getData();
            Object[] values = data.getValueRange().getValues();
            if (values.length == 0) {
                throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SHEET_BAD_DATA, String.format("Sheet %s.%s is empty", LarkSheetsUtil.mask(token), sheetId));
            }
            if (!(values[0] instanceof List)) {
                throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.LARK_API_ERROR, String.format("Illegal response data of sheet %s @ %s", LarkSheetsUtil.mask(token), range));
            }
            List header = (List)values[0];
            return header.stream().map(obj -> obj == null ? null : obj.toString()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw SimpleLarkSheetsApi.wrapApiError(e, String.format("Could not get data of sheet %s @ %s", LarkSheetsUtil.mask(token), range));
        }
    }

    @Override
    public SheetValues getValues(String token, String range) {
        try {
            SheetsService.SpreadsheetsValuesGetReqCall request = this.sheetsService.getSpreadsheetss().valuesGet(new RequestOptFn[0]);
            request.setSpreadsheetToken(token);
            request.setRange(range);
            Response response = request.execute();
            SimpleLarkSheetsApi.checkResponse(response);
            SpreadsheetsValuesGetResult data = (SpreadsheetsValuesGetResult)response.getData();
            Object[] arr = data.getValueRange().getValues();
            ArrayList<List<Object>> values = new ArrayList<List<Object>>(arr.length);
            for (Object item : arr) {
                if (!(item instanceof List)) {
                    throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.LARK_API_ERROR, String.format("Illegal response data of sheet %s @ %s", LarkSheetsUtil.mask(token), range));
                }
                values.add((List)item);
            }
            return new SheetValues(data.getRevision().intValue(), data.getValueRange().getRange(), values);
        }
        catch (Exception e) {
            throw SimpleLarkSheetsApi.wrapApiError(e, String.format("Could not get data of sheet %s @ %s", LarkSheetsUtil.mask(token), range));
        }
    }

    private static void checkResponse(Response<?> response) {
        if (response.getCode() != 0) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.LARK_API_ERROR, String.format("Bad response: [%d] %s", response.getCode(), response.getMsg()));
        }
    }

    private static PrestoException wrapApiError(Exception e, String message) {
        if (e instanceof PrestoException) {
            throw (PrestoException)e;
        }
        throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.LARK_API_ERROR, message, (Throwable)e);
    }

    private static SheetInfo toMetaInfoSheet(String token, Sheet sheet) {
        return new SheetInfo(token, sheet.getSheetId(), sheet.getTitle(), sheet.getIndex(), sheet.getColumnCount(), sheet.getRowCount());
    }
}

