/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import java.util.Comparator;
import java.util.Objects;

public class SheetInfo {
    private static final Comparator<SheetInfo> INDEX_COMPARATOR = Comparator.comparingInt(SheetInfo::getIndex);
    private final String token;
    private final String sheetId;
    private final String title;
    private final int index;
    private final int columnCount;
    private final int rowCount;

    public static Comparator<SheetInfo> indexComparator() {
        return INDEX_COMPARATOR;
    }

    public SheetInfo(String token, String sheetId, String title, int index, int columnCount, int rowCount) {
        this.token = Objects.requireNonNull(token, "spreadsheetToken is null");
        this.sheetId = Objects.requireNonNull(sheetId, "sheetId is null");
        this.title = Objects.requireNonNull(title, "title is null");
        this.index = index;
        this.columnCount = columnCount;
        this.rowCount = rowCount;
    }

    public String getToken() {
        return this.token;
    }

    public String getSheetId() {
        return this.sheetId;
    }

    public String getTitle() {
        return this.title;
    }

    public int getIndex() {
        return this.index;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SheetInfo sheetInfo = (SheetInfo)o;
        return this.index == sheetInfo.index && this.token.equals(sheetInfo.token) && this.sheetId.equals(sheetInfo.sheetId);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.sheetId, this.index);
    }

    public String toString() {
        return this.token + "." + this.sheetId + "#" + this.index;
    }
}

