/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import java.util.Objects;

public class LarkSheetsSchema {
    private final String name;
    private final String user;
    private final String token;
    private final boolean publicVisible;

    public LarkSheetsSchema(String name, String user, String token, boolean publicVisible) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.token = Objects.requireNonNull(token, "token is null");
        this.publicVisible = publicVisible;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isPublicVisible() {
        return this.publicVisible;
    }

    public boolean isVisibleTo(String user) {
        Objects.requireNonNull(user, "user is null");
        return this.publicVisible || user.equalsIgnoreCase(this.user);
    }
}

