/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import com.facebook.presto.lark.sheets.LarkSheetsConfig;
import com.facebook.presto.lark.sheets.LarkSheetsUtil;
import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.SimpleLarkSheetsApi;
import com.larksuite.oapi.core.AppSettings;
import com.larksuite.oapi.core.AppType;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.DefaultStore;
import com.larksuite.oapi.core.Domain;
import com.larksuite.oapi.core.IStore;
import com.larksuite.oapi.service.drive_permission.v2.DrivePermissionService;
import com.larksuite.oapi.service.sheets.v2.SheetsService;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class LarkSheetsApiFactory
implements Supplier<LarkSheetsApi> {
    private final DrivePermissionService drivePermissionService;
    private final SheetsService sheetsService;

    @Inject
    public LarkSheetsApiFactory(LarkSheetsConfig config) {
        this(Objects.requireNonNull(config, "config is null").getAppDomain(), config.getAppId(), config.getAppSecretFile());
    }

    public LarkSheetsApiFactory(LarkSheetsConfig.Domain domain, String appId, String appSecretFile) {
        Objects.requireNonNull(domain, "domain is null");
        Objects.requireNonNull(appId, "appId is null");
        Objects.requireNonNull(appSecretFile, "appSecretFile is null");
        String appSecret = LarkSheetsUtil.loadAppSecret(appSecretFile);
        AppSettings appSettings = new AppSettings(AppType.Internal, appId, appSecret, null, null);
        Config config = new Config(LarkSheetsApiFactory.toLarkDomain(domain), appSettings, (IStore)new DefaultStore());
        this.drivePermissionService = new DrivePermissionService(config);
        this.sheetsService = new SheetsService(config);
    }

    @Override
    public LarkSheetsApi get() {
        return new SimpleLarkSheetsApi(this.drivePermissionService, this.sheetsService);
    }

    private static Domain toLarkDomain(LarkSheetsConfig.Domain domain) {
        switch (domain) {
            case LARK: {
                return Domain.LarkSuite;
            }
            case FEISHU: {
                return Domain.FeiShu;
            }
        }
        throw new IllegalArgumentException("Invalid domain " + (Object)((Object)domain));
    }
}

