/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import com.facebook.presto.lark.sheets.LarkSheetsErrorCode;
import com.facebook.presto.lark.sheets.api.LarkSheetsSchema;
import com.facebook.presto.lark.sheets.api.LarkSheetsSchemaStore;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class InMemorySchemaStore
implements LarkSheetsSchemaStore {
    private final Map<String, LarkSheetsSchema> schemas = new ConcurrentHashMap<String, LarkSheetsSchema>();

    @Override
    public Optional<LarkSheetsSchema> get(String name) {
        return Optional.ofNullable(this.schemas.get(InMemorySchemaStore.lower(name)));
    }

    @Override
    public synchronized void insert(LarkSheetsSchema schema) {
        String name = InMemorySchemaStore.lower(schema.getName());
        if (this.schemas.containsKey(name)) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SCHEMA_ALREADY_EXISTS, String.format("Schema '%s' already exists or created by others", name));
        }
        this.schemas.put(name, schema);
    }

    @Override
    public synchronized void delete(String schemaName) {
        String name = InMemorySchemaStore.lower(schemaName);
        if (!this.schemas.containsKey(name)) {
            throw new PrestoException((ErrorCodeSupplier)LarkSheetsErrorCode.SCHEMA_NOT_EXISTS, String.format("Schema '%s' does not exist", name));
        }
        this.schemas.remove(name);
    }

    @Override
    public Iterable<LarkSheetsSchema> listForUser(String user) {
        return (Iterable)this.schemas.values().stream().filter(schema -> schema.isPublicVisible() || user.equalsIgnoreCase(schema.getUser())).collect(ImmutableList.toImmutableList());
    }

    private static String lower(String name) {
        return name.toLowerCase(Locale.ENGLISH);
    }
}

