/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets.api;

import com.facebook.presto.lark.sheets.api.LarkSheetsApi;
import com.facebook.presto.lark.sheets.api.SheetValues;
import com.facebook.presto.lark.sheets.api.SpreadsheetInfo;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class CachingLarkSheetsApi
implements LarkSheetsApi {
    private final LarkSheetsApi delegate;
    private final LoadingCache<String, Boolean> readableCache;
    private final LoadingCache<String, SpreadsheetInfo> metaInfoCache;
    private final LoadingCache<HeaderRowKey, List<String>> headerRowCache;

    public CachingLarkSheetsApi(LarkSheetsApi delegate) {
        this.delegate = delegate;
        this.readableCache = CachingLarkSheetsApi.buildCache(this::loadReadable);
        this.metaInfoCache = CachingLarkSheetsApi.buildCache(this::loadMetaInfo);
        this.headerRowCache = CachingLarkSheetsApi.buildCache(this::loadHeaderRow);
    }

    @Override
    public boolean isReadable(String token) {
        return (Boolean)this.readableCache.getUnchecked((Object)token);
    }

    private boolean loadReadable(String token) {
        return this.delegate.isReadable(token);
    }

    @Override
    public SpreadsheetInfo getMetaInfo(String token) {
        return (SpreadsheetInfo)this.metaInfoCache.getUnchecked((Object)token);
    }

    private SpreadsheetInfo loadMetaInfo(String token) {
        return this.delegate.getMetaInfo(token);
    }

    @Override
    public List<String> getHeaderRow(String token, String sheetId, int columnCount) {
        return (List)this.headerRowCache.getUnchecked((Object)new HeaderRowKey(token, sheetId, columnCount));
    }

    private List<String> loadHeaderRow(HeaderRowKey key) {
        return this.delegate.getHeaderRow(key.token, key.sheetId, key.columnCount);
    }

    @Override
    public SheetValues getValues(String token, String range) {
        return this.delegate.getValues(token, range);
    }

    private static <K, V> LoadingCache<K, V> buildCache(Function<K, V> loader) {
        return CacheBuilder.newBuilder().build(CacheLoader.from(loader::apply));
    }

    private static class HeaderRowKey {
        private final String token;
        private final String sheetId;
        private final int columnCount;

        private HeaderRowKey(String token, String sheetId, int columnCount) {
            this.token = Objects.requireNonNull(token, "token is null");
            this.sheetId = Objects.requireNonNull(sheetId, "sheetId is null");
            this.columnCount = columnCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderRowKey that = (HeaderRowKey)o;
            return this.columnCount == that.columnCount && this.token.equals(that.token) && this.sheetId.equals(that.sheetId);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.sheetId, this.columnCount);
        }
    }
}

