/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.lark.sheets;

import com.facebook.airlift.json.JsonCodec;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class LarkSheetsUtil {
    static final int RADIX = 26;
    private static final String[] ALPHABETS = LarkSheetsUtil.buildAlphabetTable();
    private static final int MASK_REMAIN = 6;

    private LarkSheetsUtil() {
    }

    public static String loadAppSecret(String secretFile) {
        Map content;
        JsonCodec codec = JsonCodec.mapJsonCodec(String.class, String.class);
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(secretFile, new String[0]));
            content = (Map)codec.fromBytes(bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read secret file " + secretFile, e);
        }
        String secret = (String)content.get("app-secret");
        if (Strings.emptyToNull((String)secret) == null) {
            throw new IllegalArgumentException("app-secret not provided in " + secretFile);
        }
        return secret;
    }

    public static String mask(String str) {
        if (str != null && str.length() > 6) {
            char[] chars = str.toCharArray();
            Arrays.fill(chars, 0, chars.length - 6, '*');
            return new String(chars);
        }
        return str;
    }

    public static int columnLabelToColumnIndex(String label) {
        Objects.requireNonNull(Strings.emptyToNull((String)label), "label is null or empty");
        int length = label.length();
        if (length == 1) {
            char c = label.charAt(0);
            return LarkSheetsUtil.charToIndex(c);
        }
        if (length == 2) {
            char a = label.charAt(0);
            char b = label.charAt(1);
            return LarkSheetsUtil.charToIndex(a) * 26 + LarkSheetsUtil.charToIndex(b) + 26;
        }
        int value = 0;
        int power = 1;
        int offset = -1;
        for (int i = length - 1; i >= 0; --i) {
            value = Math.addExact(value, Math.multiplyExact(LarkSheetsUtil.charToIndex(label.charAt(i)), power));
            offset = Math.addExact(offset, power);
            power = Math.multiplyExact(power, 26);
        }
        return value + offset;
    }

    public static String columnIndexToColumnLabel(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index must be non-negative");
        if (index < 26) {
            return ALPHABETS[index];
        }
        if (index < 702) {
            return ALPHABETS[index / 26 - 1] + ALPHABETS[index % 26];
        }
        int power = 676;
        int sum = 702;
        int width = 3;
        int position = -1;
        while (index >= sum) {
            int max = Math.addExact(power = Math.multiplyExact(power, 26), sum);
            if (index < max) {
                position = index - sum;
                break;
            }
            sum = max;
            ++width;
        }
        if (position == -1) {
            throw new IllegalStateException("Unexpected position value");
        }
        CharSequence[] chars = new String[width];
        for (int i = width - 1; i >= 0; --i) {
            chars[i] = ALPHABETS[position % 26];
            position /= 26;
        }
        return String.join((CharSequence)"", chars);
    }

    private static String[] buildAlphabetTable() {
        String[] table = new String[26];
        for (int i = 0; i < 26; ++i) {
            table[i] = Character.toString((char)(65 + i));
        }
        return table;
    }

    private static int charToIndex(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        throw new IllegalArgumentException(String.format("Illegal char '%c' in label", Character.valueOf(c)));
    }
}

